/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rpc;

import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.MessageManagerBase;
import org.jetbrains.rpc.MessageManagerBaseKt;
import org.jetbrains.rpc.RequestCallback;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\b\b\u0002\u0010\u0003*\u00020\u0004*\u0004\b\u0003\u0010\u00052\u00020\u0006:\u0001\u001dB%\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00030\f2\u0006\u0010\u0015\u001a\u00020\u0013J\u0013\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0018J!\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00028\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00030\f\u00a2\u0006\u0002\u0010\u001cR-\u0010\n\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0003 \r*\n\u0012\u0004\u0012\u00028\u0003\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/rpc/MessageManager;", "REQUEST", "INCOMING", "INCOMING_WITH_SEQ", "", "SUCCESS", "Lorg/jetbrains/rpc/MessageManagerBase;", "handler", "Lorg/jetbrains/rpc/MessageManager$Handler;", "(Lorg/jetbrains/rpc/MessageManager$Handler;)V", "callbackMap", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lorg/jetbrains/rpc/RequestCallback;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "cancelWaitingRequests", "", "failedToSend", "sequence", "", "getCallbackAndRemove", "id", "processIncoming", "incomingParsed", "(Ljava/lang/Object;)V", "send", "message", "callback", "(Ljava/lang/Object;Lorg/jetbrains/rpc/RequestCallback;)V", "Handler", "script-debugger-backend"})
public final class MessageManager<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS>
extends MessageManagerBase {
    private final ConcurrentIntObjectMap<RequestCallback<SUCCESS>> callbackMap;
    private final Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(REQUEST message2, @NotNull RequestCallback<SUCCESS> callback) {
        boolean success;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.rejectIfClosed(callback)) {
            return;
        }
        int sequence = this.handler.getUpdatedSequence(message2);
        this.callbackMap.put(sequence, callback);
        try {
            success = this.handler.write(message2);
        }
        catch (Throwable e) {
            try {
                this.failedToSend(sequence);
            }
            finally {
                CommandProcessorKt.getLOG().error("Failed to send", e);
            }
            return;
        }
        if (!success) {
            this.failedToSend(sequence);
        }
    }

    private final void failedToSend(int sequence) {
        block0: {
            RequestCallback requestCallback = (RequestCallback)this.callbackMap.remove(sequence);
            if (requestCallback == null) break block0;
            requestCallback.onError("Failed to send");
        }
    }

    public final void processIncoming(INCOMING incomingParsed) {
        INCOMING_WITH_SEQ commandResponse = this.handler.readIfHasSequence(incomingParsed);
        if (commandResponse == null) {
            if (this.getClosed()) {
                CommandProcessorKt.getLOG().info("Connection closed, ignore incoming");
            } else {
                this.handler.acceptNonSequence(incomingParsed);
            }
            return;
        }
        RequestCallback<SUCCESS> callback = this.getCallbackAndRemove(this.handler.getSequence(commandResponse, incomingParsed));
        if (this.rejectIfClosed(callback)) {
            return;
        }
        try {
            this.handler.call(commandResponse, callback);
        }
        catch (Throwable e) {
            callback.onError(e);
            CommandProcessorKt.getLOG().error("Failed to dispatch response to callback", e);
        }
    }

    @NotNull
    public final RequestCallback<SUCCESS> getCallbackAndRemove(int id) {
        RequestCallback requestCallback = (RequestCallback)this.callbackMap.remove(id);
        if (requestCallback == null) {
            throw (Throwable)new IllegalArgumentException("Cannot find callback with id " + id);
        }
        return requestCallback;
    }

    public final void cancelWaitingRequests() {
        ConcurrentIntObjectMap<RequestCallback<SUCCESS>> map2 = this.callbackMap;
        int[] keys = map2.keys();
        Arrays.sort(keys);
        for (int j = 0; j < keys.length; ++j) {
            int key2 = keys[j];
            RequestCallback requestCallback = (RequestCallback)map2.get(key2);
            if (requestCallback == null) continue;
            MessageManagerBaseKt.reject(requestCallback);
        }
    }

    public MessageManager(@NotNull Handler<REQUEST, INCOMING, INCOMING_WITH_SEQ, SUCCESS> handler2) {
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        this.handler = handler2;
        this.callbackMap = ContainerUtil.createConcurrentIntObjectMap();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0004\u0010\u0001*\u0004\b\u0005\u0010\u0002*\b\b\u0006\u0010\u0003*\u00020\u0004*\u0004\b\u0007\u0010\u00052\u00020\u0004J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0005H&\u00a2\u0006\u0002\u0010\tJ#\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00028\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00070\rH&\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0006H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u00062\u0006\u0010\b\u001a\u00028\u0005H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00028\u0004H&\u00a2\u0006\u0002\u0010\u0012J\u0017\u0010\u0016\u001a\u0004\u0018\u00018\u00062\u0006\u0010\b\u001a\u00028\u0005H&\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00028\u0004H'\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/rpc/MessageManager$Handler;", "OUTGOING", "INCOMING", "INCOMING_WITH_SEQ", "", "SUCCESS", "acceptNonSequence", "", "incoming", "(Ljava/lang/Object;)V", "call", "response", "callback", "Lorg/jetbrains/rpc/RequestCallback;", "(Ljava/lang/Object;Lorg/jetbrains/rpc/RequestCallback;)V", "getSequence", "", "incomingWithSeq", "(Ljava/lang/Object;)I", "(Ljava/lang/Object;Ljava/lang/Object;)I", "getUpdatedSequence", "message", "readIfHasSequence", "(Ljava/lang/Object;)Ljava/lang/Object;", "write", "", "(Ljava/lang/Object;)Z", "script-debugger-backend"})
    public static interface Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS> {
        public int getUpdatedSequence(OUTGOING var1);

        public boolean write(OUTGOING var1) throws IOException;

        @Nullable
        public INCOMING_WITH_SEQ readIfHasSequence(INCOMING var1);

        public int getSequence(@NotNull INCOMING_WITH_SEQ var1);

        public int getSequence(@NotNull INCOMING_WITH_SEQ var1, INCOMING var2);

        public void acceptNonSequence(INCOMING var1);

        public void call(@NotNull INCOMING_WITH_SEQ var1, @NotNull RequestCallback<SUCCESS> var2);

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=3)
        public static final class DefaultImpls {
            public static <OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS> int getSequence(@NotNull Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS> $this, INCOMING_WITH_SEQ incomingWithSeq) {
                Intrinsics.checkParameterIsNotNull(incomingWithSeq, (String)"incomingWithSeq");
                throw (Throwable)new AbstractMethodError();
            }

            public static <OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS> int getSequence(@NotNull Handler<OUTGOING, INCOMING, INCOMING_WITH_SEQ, SUCCESS> $this, INCOMING_WITH_SEQ incomingWithSeq, INCOMING incoming) {
                Intrinsics.checkParameterIsNotNull(incomingWithSeq, (String)"incomingWithSeq");
                return $this.getSequence(incomingWithSeq);
            }
        }
    }
}

