/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class JavaFxSchemaProvider
extends XmlSchemaProvider {
    private static final Logger LOG = Logger.getInstance(JavaFxSchemaProvider.class);

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/JavaFxSchemaProvider", "isAvailable"));
        }
        return JavaFxFileTypeFactory.isFxml((PsiFile)file);
    }

    @Nullable
    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/javaFX/fxml/JavaFxSchemaProvider", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "org/jetbrains/plugins/javaFX/fxml/JavaFxSchemaProvider", "getSchema"));
        }
        return module != null && JavaFxFileTypeFactory.isFxml(baseFile) ? JavaFxSchemaProvider.getReference(module) : null;
    }

    private static XmlFile getReference(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/javaFX/fxml/JavaFxSchemaProvider", "getReference"));
        }
        URL resource = JavaFxSchemaProvider.class.getResource("fx.xsd");
        VirtualFile fileByURL = VfsUtil.findFileByURL((URL)resource);
        if (fileByURL == null) {
            LOG.error("xsd not found");
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(fileByURL);
        LOG.assertTrue(psiFile != null);
        return (XmlFile)psiFile.copy();
    }
}

