/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;

public class JavaFxColorRgbInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection", "buildVisitor"));
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiClass psiClass;
                super.visitXmlAttribute(attribute);
                String attributeValue = attribute.getValue();
                if (attributeValue == null) {
                    return;
                }
                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                if (descriptor instanceof JavaFxPropertyAttributeDescriptor && (psiClass = ((JavaFxPropertyAttributeDescriptor)descriptor).getPsiClass()) != null && "javafx.scene.paint.Color".equals(psiClass.getQualifiedName())) {
                    XmlAttributeValue valueElement = attribute.getValueElement();
                    XmlAttributeValue location = valueElement != null ? valueElement : attribute;
                    this.validateColorComponent(psiClass, attribute.getName(), attributeValue, (PsiElement)location);
                }
            }

            public void visitXmlTag(XmlTag tag) {
                PsiClass psiClass;
                super.visitXmlTag(tag);
                if (tag.getSubTags().length != 0) {
                    return;
                }
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (descriptor instanceof JavaFxPropertyTagDescriptor && (psiClass = ((JavaFxPropertyTagDescriptor)descriptor).getPsiClass()) != null && "javafx.scene.paint.Color".equals(psiClass.getQualifiedName())) {
                    XmlTagValue valueElement = tag.getValue();
                    XmlText[] textElements = valueElement.getTextElements();
                    XmlTag location = textElements.length == 1 ? textElements[0] : tag;
                    this.validateColorComponent(psiClass, tag.getName(), valueElement.getTrimmedText(), (PsiElement)location);
                }
            }

            private void validateColorComponent(@NotNull PsiClass psiClass, @NotNull String propertyName, @NotNull String propertyValue, @NotNull PsiElement location) {
                if (psiClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection$1", "validateColorComponent"));
                }
                if (propertyName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection$1", "validateColorComponent"));
                }
                if (propertyValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyValue", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection$1", "validateColorComponent"));
                }
                if (location == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection$1", "validateColorComponent"));
                }
                PsiMember declaration = JavaFxPsiUtil.getWritableProperties(psiClass).get(propertyName);
                String boxedQName = JavaFxPsiUtil.getBoxedPropertyType(psiClass, declaration);
                if ("java.lang.Float".equals(boxedQName) || "java.lang.Double".equals(boxedQName)) {
                    try {
                        double value = Double.parseDouble(propertyValue);
                        if (value < 0.0 || value > 1.0) {
                            holder.registerProblem(location, "Color component has to be a number between 0.0 and 1.0, inclusively", new LocalQuickFix[0]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxColorRgbInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }
}

