/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxEventHandlerReference;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxPropertyReference;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxScopeEnlarger;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxStaticPropertyReference;
import org.jetbrains.plugins.javaFX.refactoring.JavaFxPropertyElement;

public class JavaFxMethodSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        JavaFxPropertyElement propertyElement;
        JavaFxPropertyReference propertyReference;
        PsiMethod staticSetter;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "execute"));
        }
        PsiElement elementToSearch = queryParameters.getElementToSearch();
        if (elementToSearch instanceof PsiMethod) {
            JavaFxMethodSearcher.searchMethod((PsiMethod)elementToSearch, queryParameters, consumer);
        }
        if (elementToSearch instanceof JavaFxPropertyElement && (staticSetter = (propertyReference = (propertyElement = (JavaFxPropertyElement)elementToSearch).getPropertyReference()).getStaticSetter()) != null) {
            JavaFxMethodSearcher.searchMethod(staticSetter, queryParameters, consumer);
        }
        return true;
    }

    private static void searchMethod(@NotNull PsiMethod psiMethod, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "searchMethod"));
        }
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "searchMethod"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "searchMethod"));
        }
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)psiMethod);
        SearchScope scope = (SearchScope)ReadAction.compute(() -> ((ReferencesSearch.SearchParameters)queryParameters).getEffectiveSearchScope());
        if (scope instanceof LocalSearchScope) {
            VirtualFile[] vFiles;
            for (VirtualFile vFile : vFiles = ((LocalSearchScope)scope).getVirtualFiles()) {
                Boolean goOn;
                PsiFile psiFile;
                if (JavaFxFileTypeFactory.isFxml(vFile) && (psiFile = PsiManager.getInstance((Project)project).findFile(vFile)) != null && !(goOn = (Boolean)ReadAction.compute(() -> {
                    if (psiMethod == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "lambda$searchMethod$0"));
                    }
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "lambda$searchMethod$0"));
                    }
                    return JavaFxMethodSearcher.searchMethodInFile(psiMethod, psiFile, consumer);
                })).booleanValue()) break;
            }
        } else if (scope instanceof GlobalSearchScope) {
            String propertyName = (String)ReadAction.compute(() -> {
                if (psiMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "lambda$searchMethod$1"));
                }
                return PropertyUtil.getPropertyName((String)psiMethod.getName());
            });
            if (propertyName == null) {
                return;
            }
            String className = (String)ReadAction.compute(() -> {
                if (psiMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "lambda$searchMethod$2"));
                }
                PsiClass psiClass = psiMethod.getContainingClass();
                return psiClass != null ? psiClass.getName() : null;
            });
            if (className == null) {
                return;
            }
            JavaFxScopeEnlarger.GlobalFxmlSearchScope fxmlScope = new JavaFxScopeEnlarger.GlobalFxmlSearchScope((GlobalSearchScope)scope);
            Object[] filteredFiles = (VirtualFile[])ReadAction.compute(() -> JavaFxMethodSearcher.lambda$searchMethod$3(project, className, (GlobalSearchScope)fxmlScope));
            if (ArrayUtil.isEmpty((Object[])filteredFiles)) {
                return;
            }
            GlobalSearchScope filteredScope = GlobalSearchScope.filesScope((Project)project, (Collection)ContainerUtil.newHashSet((Object[])filteredFiles));
            ApplicationManager.getApplication().runReadAction(() -> {
                if (psiMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "lambda$searchMethod$5"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "lambda$searchMethod$5"));
                }
                CacheManager.SERVICE.getInstance((Project)project).processFilesWithWord(file -> {
                    if (psiMethod == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "lambda$null$4"));
                    }
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "lambda$null$4"));
                    }
                    return JavaFxMethodSearcher.searchMethodInFile(psiMethod, file, consumer);
                }, propertyName, (short)16, filteredScope, true);
            });
        }
    }

    private static boolean searchMethodInFile(final @NotNull PsiMethod psiMethod, @NotNull PsiFile file, final @NotNull Processor<PsiReference> consumer) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "searchMethodInFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "searchMethodInFile"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher", "searchMethodInFile"));
        }
        final Ref stopped = new Ref((Object)false);
        file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlElement(XmlElement element) {
                if (((Boolean)stopped.get()).booleanValue()) {
                    return;
                }
                super.visitXmlElement(element);
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiReference[] references;
                if (((Boolean)stopped.get()).booleanValue()) {
                    return;
                }
                for (PsiReference reference : references = attribute.getReferences()) {
                    if (!(reference instanceof JavaFxStaticPropertyReference) && !(reference instanceof JavaFxEventHandlerReference) || !reference.isReferenceTo((PsiElement)psiMethod) || consumer.process((Object)reference)) continue;
                    stopped.set((Object)true);
                    return;
                }
            }
        });
        return (Boolean)stopped.get() == false;
    }

    private static /* synthetic */ VirtualFile[] lambda$searchMethod$3(Project project, String className, GlobalSearchScope fxmlScope) throws RuntimeException {
        return CacheManager.SERVICE.getInstance((Project)project).getVirtualFilesWithWord(className, (short)16, fxmlScope, true);
    }
}

