/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

public class GroupingMessageCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final Multimap<String, Message> groupedMessages;

    public GroupingMessageCollector(@NotNull MessageCollector delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "<init>"));
        }
        this.groupedMessages = LinkedHashMultimap.create();
        this.delegate = delegate;
    }

    @Override
    public void clear() {
        this.groupedMessages.clear();
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            this.delegate.report(severity, message, location);
        } else {
            this.groupedMessages.put((Object)(location != null ? location.getPath() : null), (Object)new Message(severity, message, location));
        }
    }

    @Override
    public boolean hasErrors() {
        return this.groupedMessages.entries().stream().anyMatch(entry -> ((Message)entry.getValue()).severity.isError());
    }

    public void flush() {
        boolean hasErrors = this.hasErrors();
        for (String path : this.sortedKeys()) {
            for (Message message : this.groupedMessages.get((Object)path)) {
                if (hasErrors && !message.severity.isError() && message.severity != CompilerMessageSeverity.STRONG_WARNING) continue;
                this.delegate.report(message.severity, message.message, message.location);
            }
        }
        this.groupedMessages.clear();
    }

    @NotNull
    private Collection<String> sortedKeys() {
        ArrayList<String> sortedKeys = new ArrayList<String>(this.groupedMessages.keySet());
        sortedKeys.sort(Comparator.nullsFirst(Comparator.naturalOrder()));
        ArrayList<String> arrayList = sortedKeys;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "sortedKeys"));
        }
        return arrayList;
    }

    private static class Message {
        private final CompilerMessageSeverity severity;
        private final String message;
        private final CompilerMessageLocation location;

        private Message(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            this.severity = severity;
            this.message = message;
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message other = (Message)o;
            if (!Objects.equals(this.location, other.location)) {
                return false;
            }
            if (!this.message.equals(other.message)) {
                return false;
            }
            return this.severity == other.severity;
        }

        public int hashCode() {
            int result = this.severity.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "[" + (Object)((Object)this.severity) + "] " + this.message + (this.location != null ? " (at " + this.location + ")" : " (no location)");
        }
    }
}

