/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.preloading.ClassCondition;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;", "kotlinPaths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "services", "Lorg/jetbrains/kotlin/config/Services;", "classesToLoadByParent", "Lorg/jetbrains/kotlin/preloading/ClassCondition;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "outputItemsCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "(Lorg/jetbrains/kotlin/utils/KotlinPaths;Lorg/jetbrains/kotlin/config/Services;Lorg/jetbrains/kotlin/preloading/ClassCondition;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;)V", "getClassesToLoadByParent", "()Lorg/jetbrains/kotlin/preloading/ClassCondition;", "getKotlinPaths", "()Lorg/jetbrains/kotlin/utils/KotlinPaths;", "getOutputItemsCollector", "()Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "reportErrorsTo", "", "success", "", "jps-plugin"})
public final class JpsCompilerEnvironment
extends CompilerEnvironment {
    @NotNull
    private final KotlinPaths kotlinPaths;
    @NotNull
    private final ClassCondition classesToLoadByParent;
    @NotNull
    private final OutputItemsCollectorImpl outputItemsCollector;

    public final boolean success() {
        return this.kotlinPaths.getHomePath().exists();
    }

    public final void reportErrorsTo(@NotNull MessageCollector messageCollector) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        if (!this.kotlinPaths.getHomePath().exists()) {
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Cannot find kotlinc home: " + this.kotlinPaths.getHomePath() + ". Make sure plugin is properly installed, " + "or specify " + "jps.kotlin.home" + " system property", null, 4, null);
        }
    }

    @NotNull
    public final KotlinPaths getKotlinPaths() {
        return this.kotlinPaths;
    }

    @NotNull
    public final ClassCondition getClassesToLoadByParent() {
        return this.classesToLoadByParent;
    }

    @Override
    @NotNull
    public OutputItemsCollectorImpl getOutputItemsCollector() {
        return this.outputItemsCollector;
    }

    public JpsCompilerEnvironment(@NotNull KotlinPaths kotlinPaths, @NotNull Services services, @NotNull ClassCondition classesToLoadByParent, @NotNull MessageCollector messageCollector, @NotNull OutputItemsCollectorImpl outputItemsCollector) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinPaths, (String)"kotlinPaths");
        Intrinsics.checkParameterIsNotNull((Object)services, (String)"services");
        Intrinsics.checkParameterIsNotNull((Object)classesToLoadByParent, (String)"classesToLoadByParent");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)outputItemsCollector, (String)"outputItemsCollector");
        super(services, messageCollector, outputItemsCollector);
        this.kotlinPaths = kotlinPaths;
        this.classesToLoadByParent = classesToLoadByParent;
        this.outputItemsCollector = outputItemsCollector;
    }
}

