/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.noarg.diagnostic;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.extensions.AnnotationBasedExtension;
import org.jetbrains.kotlin.noarg.NoArgClassKeyKt;
import org.jetbrains.kotlin.noarg.diagnostic.ErrorsNoArg;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/noarg/diagnostic/AbstractNoArgDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "Lorg/jetbrains/kotlin/extensions/AnnotationBasedExtension;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isNoArgConstructor", "", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "noarg-cli"})
public abstract class AbstractNoArgDeclarationChecker
implements DeclarationChecker,
AnnotationBasedExtension {
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (!(descriptor instanceof ClassDescriptor) || !(declaration instanceof KtClass)) {
            return;
        }
        if (Intrinsics.areEqual((Object)((ClassDescriptor)descriptor).getKind(), (Object)ClassKind.CLASS) ^ true) {
            return;
        }
        boolean hasSpecialAnnotation = this.hasSpecialAnnotation(descriptor, (KtModifierListOwner)declaration);
        declaration.putUserData(NoArgClassKeyKt.getNO_ARG_CLASS_KEY(), (Object)hasSpecialAnnotation);
        if (hasSpecialAnnotation) {
            boolean bl;
            ClassDescriptor superClass;
            block7: {
                superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)((ClassDescriptor)descriptor));
                Iterable $receiver$iv = superClass.getConstructors();
                for (Object element$iv : $receiver$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    if (!this.isNoArgConstructor((ConstructorDescriptor)it)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (bl && !this.hasSpecialAnnotation((DeclarationDescriptor)superClass, (KtModifierListOwner)declaration)) {
                PsiElement psiElement;
                PsiElement psiElement2 = ((KtClass)declaration).getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = psiElement = ((KtClass)declaration).getClassOrInterfaceKeyword();
                }
                if (psiElement2 == null) {
                    psiElement = (PsiElement)declaration;
                }
                PsiElement reportTarget = psiElement;
                diagnosticHolder.report((Diagnostic)ErrorsNoArg.NO_NOARG_CONSTRUCTOR_IN_SUPERCLASS.on(reportTarget));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNoArgConstructor(@NotNull ConstructorDescriptor $receiver) {
        Object element$iv;
        ValueParameterDescriptor it;
        if ($receiver.getValueParameters().isEmpty()) return true;
        Iterable $receiver$iv = $receiver.getValueParameters();
        Iterator iterator = $receiver$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (DescriptorUtilsKt.hasDefaultValue((ValueParameterDescriptor)(it = (ValueParameterDescriptor)(element$iv = iterator.next()))));
        return false;
    }

    public boolean hasSpecialAnnotation(@NotNull DeclarationDescriptor $receiver, @Nullable KtModifierListOwner modifierListOwner) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return AnnotationBasedExtension.DefaultImpls.hasSpecialAnnotation((AnnotationBasedExtension)this, (DeclarationDescriptor)$receiver, (KtModifierListOwner)modifierListOwner);
    }
}

