/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.EventAction;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StackedEventComponent
extends AnimatedComponent {
    private static final Color DISABLED_ACTION = new Color(221, 222, 224);
    private static final Color ENABLED_ACTION = new Color(106, 189, 180);
    private static final int CHARACTERS_TO_SHRINK_BY = 1;
    private static final int SEGMENT_SPACING = 5;
    @NotNull
    private final RangedSeries<EventAction<EventAction.ActivityAction, String>> mData;
    private float myLineThickness;
    private HashMap<EventAction<EventAction.ActivityAction, String>, EventRenderData> myActionToDrawLocationMap;
    private List<EventRenderData> myActivities;

    public StackedEventComponent(@NotNull RangedSeries<EventAction<EventAction.ActivityAction, String>> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/adtui/StackedEventComponent", "<init>"));
        }
        this.myLineThickness = 6.0f;
        this.myActionToDrawLocationMap = new HashMap();
        this.myActivities = new ArrayList<EventRenderData>();
        this.mData = data;
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
    }

    @Override
    protected void updateData() {
        double min = this.mData.getXRange().getMin();
        double max = this.mData.getXRange().getMax();
        this.myActivities.clear();
        this.myActionToDrawLocationMap.clear();
        ImmutableList<SeriesData<EventAction<EventAction.ActivityAction, String>>> series = this.mData.getSeries();
        int size = series.size();
        for (int i = 0; i < size; ++i) {
            SeriesData seriesData = (SeriesData)series.get(i);
            EventAction data = (EventAction)seriesData.value;
            Path2D.Float path = new Path2D.Float();
            double endTime = data.getEndUs() == 0L ? max : (double)data.getEndUs();
            double normalizedEndPosition = (endTime - min) / (max - min);
            double normalizedstartPosition = ((double)data.getStartUs() - min) / (max - min);
            path.moveTo(normalizedEndPosition, 1.0);
            path.lineTo(normalizedstartPosition, 1.0);
            this.myActivities.add(new EventRenderData(data, path));
        }
        this.myActivities.sort((erd1, erd2) -> {
            if (erd1.getAction().getEndUs() == 0L && erd2.getAction().getEndUs() != 0L) {
                return -1;
            }
            if (erd1.getAction().getEndUs() != 0L && erd2.getAction().getEndUs() == 0L) {
                return 1;
            }
            if (erd1.getAction().getEndUs() != 0L && erd2.getAction().getEndUs() != 0L) {
                return erd1.getAction().getEndUs() - erd2.getAction().getEndUs() >= 0L ? 1 : -1;
            }
            return erd1.getAction().getStartUs() - erd2.getAction().getStartUs() >= 0L ? 1 : -1;
        });
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        int scaleFactor = dim.width;
        double min = this.mData.getXRange().getMin();
        double max = this.mData.getXRange().getMax();
        FontMetrics metrics = g2d.getFontMetrics();
        Stroke current = g2d.getStroke();
        BasicStroke str = new BasicStroke(this.myLineThickness);
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, dim.height - 5);
        Iterator<EventRenderData> itor = this.myActivities.iterator();
        g2d.setFont(this.getFont());
        while (itor.hasNext()) {
            g2d.setStroke(str);
            EventRenderData renderData = itor.next();
            EventAction<EventAction.ActivityAction, String> event = renderData.getAction();
            if (event.getEndUs() != 0L) {
                g2d.setColor(DISABLED_ACTION);
            } else {
                g2d.setColor(ENABLED_ACTION);
            }
            Shape shape = scale.createTransformedShape(renderData.getPath());
            g2d.draw(shape);
            g2d.setStroke(current);
            String text = event.getValueData();
            int width = metrics.stringWidth(text);
            int height = metrics.getHeight();
            double normalizedStartPosition = ((double)event.getStartUs() - min) / (max - min);
            double lifetime = event.getEndUs() - event.getStartUs();
            if (event.getEndUs() == 0L) {
                lifetime = max - (double)event.getStartUs();
            }
            double normalizedEndPosition = ((double)event.getStartUs() + lifetime - min) / (max - min);
            float startPosition = (float)normalizedStartPosition * (float)scaleFactor;
            float endPosition = (float)normalizedEndPosition * (float)scaleFactor;
            boolean ellipsis = true;
            if (startPosition < 0.0f && endPosition > 0.0f) {
                startPosition = (float)width < endPosition ? 0.0f : endPosition - (float)width;
                ellipsis = false;
            }
            if (ellipsis && (text = AdtUiUtils.getFittedString(metrics, text, endPosition - startPosition, 1)).isEmpty()) continue;
            if (event.getEndUs() != 0L) {
                g2d.setColor(DISABLED_ACTION);
            } else {
                g2d.setColor(ENABLED_ACTION);
            }
            g2d.drawString(text, startPosition, this.myLineThickness + 5.0f);
        }
    }

    @Override
    protected void debugDraw(Graphics2D g) {
        super.debugDraw(g);
    }

    public void setLineThickness(float lineThickness) {
        this.myLineThickness = lineThickness;
    }

    private static class EventRenderData {
        private final EventAction<EventAction.ActivityAction, String> mAction;
        private final Path2D mPath;

        public EventAction<EventAction.ActivityAction, String> getAction() {
            return this.mAction;
        }

        public Path2D getPath() {
            return this.mPath;
        }

        public EventRenderData(EventAction<EventAction.ActivityAction, String> action, Path2D path) {
            this.mAction = action;
            this.mPath = path;
        }
    }
}

