/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.WorkBench;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.intellij.openapi.components.ServiceManager;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class WorkBenchManager {
    private Multimap<String, WorkBench> myWorkBenches = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    public static WorkBenchManager getInstance() {
        return (WorkBenchManager)ServiceManager.getService(WorkBenchManager.class);
    }

    public void register(@NotNull WorkBench workBench) {
        if (workBench == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workBench", "com/android/tools/adtui/workbench/WorkBenchManager", "register"));
        }
        this.myWorkBenches.put((Object)workBench.getName(), (Object)workBench);
    }

    public void unregister(@NotNull WorkBench workBench) {
        if (workBench == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workBench", "com/android/tools/adtui/workbench/WorkBenchManager", "unregister"));
        }
        this.myWorkBenches.remove((Object)workBench.getName(), (Object)workBench);
    }

    public void storeDefaultLayout() {
        for (String name : this.myWorkBenches.keySet()) {
            Optional workbench = this.myWorkBenches.get((Object)name).stream().findFirst();
            if (!workbench.isPresent()) continue;
            ((WorkBench)((Object)workbench.get())).storeDefaultLayout();
            this.updateOtherWorkBenches((WorkBench)((Object)workbench.get()));
        }
    }

    public void restoreDefaultLayout() {
        for (String name : this.myWorkBenches.keySet()) {
            Optional workbench = this.myWorkBenches.get((Object)name).stream().findFirst();
            if (!workbench.isPresent()) continue;
            ((WorkBench)((Object)workbench.get())).restoreDefaultLayout();
            this.updateOtherWorkBenches((WorkBench)((Object)workbench.get()));
        }
    }

    public void updateOtherWorkBenches(@NotNull WorkBench workBench) {
        if (workBench == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workBench", "com/android/tools/adtui/workbench/WorkBenchManager", "updateOtherWorkBenches"));
        }
        Collection workBenches = this.myWorkBenches.get((Object)workBench.getName());
        workBenches.stream().filter(bench -> {
            if (workBench == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workBench", "com/android/tools/adtui/workbench/WorkBenchManager", "lambda$updateOtherWorkBenches$0"));
            }
            return bench != workBench;
        }).forEach(WorkBench::updateModel);
    }
}

