/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

@Deprecated
public class RepositoryAttachHandler {
    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project, @Nullable String initialFilter, JComponent parentComponent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "chooseLibraryAndDownload"));
        }
        return JarRepositoryManager.chooseLibraryAndDownload((Project)project, (String)initialFilter, (JComponent)parentComponent);
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(Project project, String coord, boolean attachJavaDoc, boolean attachSources, @Nullable String copyTo, List<MavenRepositoryInfo> repositories) {
        ArrayList repos = repositories.stream().map(info -> RepositoryAttachHandler.toRemoteRepositoryDescription(info)).collect(Collectors.toCollection(ArrayList::new));
        return JarRepositoryManager.resolveAndDownload((Project)project, (String)coord, (boolean)attachSources, (boolean)attachJavaDoc, (boolean)true, (String)copyTo, (Collection)repos);
    }

    @NotNull
    public static List<OrderRoot> resolveAndDownloadImpl(Project project, String coord, boolean attachJavaDoc, boolean attachSources, @Nullable String copyTo, List<MavenRepositoryInfo> repositories, ProgressIndicator indicator) {
        ArrayList repos = repositories.stream().map(info -> RepositoryAttachHandler.toRemoteRepositoryDescription(info)).collect(Collectors.toCollection(ArrayList::new));
        ArrayList<OrderRoot> arrayList = new ArrayList<OrderRoot>(JarRepositoryManager.loadDependencies((Project)project, (RepositoryLibraryProperties)new RepositoryLibraryProperties(coord, true), (boolean)attachSources, (boolean)attachJavaDoc, (String)copyTo, (Collection)repos));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "resolveAndDownloadImpl"));
        }
        return arrayList;
    }

    public static void searchArtifacts(Project project, String coord, PairProcessor<Collection<Pair<MavenArtifactInfo, MavenRepositoryInfo>>, Boolean> resultProcessor) {
        JarRepositoryManager.searchArtifacts((Project)project, (String)coord, (T pairs) -> resultProcessor.process(RepositoryAttachHandler.convert(pairs), (Object)Boolean.FALSE));
    }

    public static void searchRepositories(Project project, Collection<String> nexusUrls, Processor<Collection<MavenRepositoryInfo>> resultProcessor) {
        JarRepositoryManager.searchRepositories((Project)project, nexusUrls, descriptions -> resultProcessor.process(RepositoryAttachHandler.convertRepositoryList(descriptions)));
    }

    public static MavenId getMavenId(@NotNull String coord) {
        if (coord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coord", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "getMavenId"));
        }
        String[] parts = coord.split(":");
        return new MavenId(parts.length > 0 ? parts[0] : null, parts.length > 1 ? parts[1] : null, parts.length > 2 ? parts[2] : null);
    }

    private static Collection<Pair<MavenArtifactInfo, MavenRepositoryInfo>> convert(Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>> in) {
        return in.stream().map(p -> Pair.create((Object)RepositoryAttachHandler.toMavenArtifactInfo((RepositoryArtifactDescription)p.first), (Object)RepositoryAttachHandler.toMavenRepositoryInfo((RemoteRepositoryDescription)p.second))).collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    private static MavenArtifactInfo toMavenArtifactInfo(RepositoryArtifactDescription ad) {
        MavenArtifactInfo mavenArtifactInfo = new MavenArtifactInfo(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), ad.getPackaging(), ad.getClassifier(), ad.getClassNames(), ad.getRepositoryId());
        if (mavenArtifactInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "toMavenArtifactInfo"));
        }
        return mavenArtifactInfo;
    }

    @NotNull
    private static MavenRepositoryInfo toMavenRepositoryInfo(RemoteRepositoryDescription repo) {
        MavenRepositoryInfo mavenRepositoryInfo = new MavenRepositoryInfo(repo.getId(), repo.getName(), repo.getUrl());
        if (mavenRepositoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "toMavenRepositoryInfo"));
        }
        return mavenRepositoryInfo;
    }

    @NotNull
    private static RemoteRepositoryDescription toRemoteRepositoryDescription(MavenRepositoryInfo repo) {
        RemoteRepositoryDescription remoteRepositoryDescription = new RemoteRepositoryDescription(repo.getId(), repo.getName(), repo.getUrl());
        if (remoteRepositoryDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "toRemoteRepositoryDescription"));
        }
        return remoteRepositoryDescription;
    }

    @NotNull
    private static Collection<MavenRepositoryInfo> convertRepositoryList(Collection<RemoteRepositoryDescription> repos) {
        if (repos.isEmpty()) {
            List<MavenRepositoryInfo> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "convertRepositoryList"));
            }
            return list;
        }
        ArrayList<MavenRepositoryInfo> result = new ArrayList<MavenRepositoryInfo>();
        for (RemoteRepositoryDescription description : repos) {
            result.add(RepositoryAttachHandler.toMavenRepositoryInfo(description));
        }
        ArrayList<MavenRepositoryInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "convertRepositoryList"));
        }
        return arrayList;
    }
}

