/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.LineMarkerSettings;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GutterIconDescriptor {
    protected static final Option[] NO_OPTIONS = new Option[0];

    @Nullable(value="null means disabled")
    public abstract String getName();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public String getId() {
        return this.getClass().getName();
    }

    @NotNull
    public Option[] getOptions() {
        if (NO_OPTIONS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/GutterIconDescriptor", "getOptions"));
        }
        return NO_OPTIONS;
    }

    public String toString() {
        return this.getName();
    }

    public static class Option
    extends GutterIconDescriptor {
        private final String myId;
        private final String myName;
        private final Icon myIcon;

        public Option(@NotNull String id, @NotNull String name, Icon icon) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInsight/daemon/GutterIconDescriptor$Option", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/GutterIconDescriptor$Option", "<init>"));
            }
            this.myId = id;
            this.myName = name;
            this.myIcon = icon;
        }

        public boolean isEnabled() {
            return LineMarkerSettings.getSettings().isEnabled(this);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/GutterIconDescriptor$Option", "getName"));
            }
            return string;
        }

        @Override
        public String getId() {
            return this.myId;
        }
    }
}

