/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.ActionClassHolder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionWrapper
implements LocalQuickFix,
IntentionAction,
ActionClassHolder,
IntentionActionDelegate {
    private final IntentionAction myAction;
    private final PsiFile myFile;

    public IntentionWrapper(@NotNull IntentionAction action, @NotNull PsiFile file) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/IntentionWrapper", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/IntentionWrapper", "<init>"));
        }
        this.myAction = action;
        this.myFile = file;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myAction.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myAction.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.myAction.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/IntentionWrapper", "isAvailable"));
        }
        return this.myAction.isAvailable(project, editor, file);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/IntentionWrapper", "invoke"));
        }
        this.myAction.invoke(project, editor, file);
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/IntentionWrapper", "getElementToMakeWritable"));
        }
        return this.myAction.getElementToMakeWritable(file);
    }

    @Override
    public boolean startInWriteAction() {
        return this.myAction.startInWriteAction();
    }

    @NotNull
    public IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "getAction"));
        }
        return intentionAction;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/IntentionWrapper", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/IntentionWrapper", "applyFix"));
        }
        VirtualFile virtualFile2 = this.myFile.getVirtualFile();
        if (virtualFile2 != null) {
            FileEditor editor = FileEditorManager.getInstance(project).getSelectedEditor(virtualFile2);
            this.myAction.invoke(project, editor instanceof TextEditor ? ((TextEditor)editor).getEditor() : null, this.myFile);
        }
    }

    @Override
    @NotNull
    public Class getActionClass() {
        Class<?> clazz = this.getAction().getClass();
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "getActionClass"));
        }
        return clazz;
    }

    @Override
    @NotNull
    public IntentionAction getDelegate() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "getDelegate"));
        }
        return intentionAction;
    }

    @Contract(value="null, _ -> null")
    public static LocalQuickFix wrapToQuickFix(@Nullable IntentionAction action, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/IntentionWrapper", "wrapToQuickFix"));
        }
        if (action == null) {
            return null;
        }
        if (action instanceof LocalQuickFix) {
            return (LocalQuickFix)((Object)action);
        }
        return new IntentionWrapper(action, file);
    }

    @NotNull
    public static LocalQuickFix[] wrapToQuickFixes(@NotNull IntentionAction[] actions, @NotNull PsiFile file) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInspection/IntentionWrapper", "wrapToQuickFixes"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/IntentionWrapper", "wrapToQuickFixes"));
        }
        if (actions.length == 0) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "wrapToQuickFixes"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] fixes = new LocalQuickFix[actions.length];
        for (int i2 = 0; i2 < actions.length; ++i2) {
            fixes[i2] = IntentionWrapper.wrapToQuickFix(actions[i2], file);
        }
        if (fixes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "wrapToQuickFixes"));
        }
        return fixes;
    }

    @NotNull
    public static List<LocalQuickFix> wrapToQuickFixes(@NotNull List<IntentionAction> actions, @NotNull PsiFile file) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInspection/IntentionWrapper", "wrapToQuickFixes"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/IntentionWrapper", "wrapToQuickFixes"));
        }
        if (actions.isEmpty()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "wrapToQuickFixes"));
            }
            return list;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(actions.size());
        for (IntentionAction action : actions) {
            fixes.add(IntentionWrapper.wrapToQuickFix(action, file));
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/IntentionWrapper", "wrapToQuickFixes"));
        }
        return arrayList;
    }
}

