/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public abstract class UniqueVFilePathBuilder {
    private static final UniqueVFilePathBuilder DUMMY_BUILDER = new UniqueVFilePathBuilder(){

        @Override
        @NotNull
        public String getUniqueVirtualFilePath(@NotNull Project project, @NotNull VirtualFile vFile) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder$1", "getUniqueVirtualFilePath"));
            }
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder$1", "getUniqueVirtualFilePath"));
            }
            String string = vFile.getPresentableName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder$1", "getUniqueVirtualFilePath"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getUniqueVirtualFilePathWithinOpenedFileEditors(@NotNull Project project, @NotNull VirtualFile vFile) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder$1", "getUniqueVirtualFilePathWithinOpenedFileEditors"));
            }
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder$1", "getUniqueVirtualFilePathWithinOpenedFileEditors"));
            }
            String string = vFile.getPresentableName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder$1", "getUniqueVirtualFilePathWithinOpenedFileEditors"));
            }
            return string;
        }
    };

    public static UniqueVFilePathBuilder getInstance() {
        UniqueVFilePathBuilder service = ServiceManager.getService(UniqueVFilePathBuilder.class);
        return service != null ? service : DUMMY_BUILDER;
    }

    @NotNull
    public String getUniqueVirtualFilePath(@NotNull Project project, @NotNull VirtualFile vFile, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder", "getUniqueVirtualFilePath"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder", "getUniqueVirtualFilePath"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder", "getUniqueVirtualFilePath"));
        }
        String string = this.getUniqueVirtualFilePath(project, vFile);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/UniqueVFilePathBuilder", "getUniqueVirtualFilePath"));
        }
        return string;
    }

    @NotNull
    public abstract String getUniqueVirtualFilePath(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract String getUniqueVirtualFilePathWithinOpenedFileEditors(@NotNull Project var1, @NotNull VirtualFile var2);
}

