/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkVersionUtil {
    public static boolean isAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion minVersion) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/JavaSdkVersionUtil", "isAtLeast"));
        }
        if (minVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minVersion", "com/intellij/openapi/projectRoots/JavaSdkVersionUtil", "isAtLeast"));
        }
        JavaSdkVersion version = JavaSdkVersionUtil.getJavaSdkVersion(element);
        return version == null || version.isAtLeast(minVersion);
    }

    public static JavaSdkVersion getJavaSdkVersion(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/projectRoots/JavaSdkVersionUtil", "getJavaSdkVersion"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(element);
        return module != null ? JavaSdkVersionUtil.getJavaSdkVersion(ModuleRootManager.getInstance(module).getSdk()) : null;
    }

    public static JavaSdkVersion getJavaSdkVersion(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkType() instanceof JavaSdk ? ((JavaSdk)sdk.getSdkType()).getVersion(sdk) : null;
    }
}

