/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesUtil {
    private static final Key<Boolean> INTERNAL_OPERATION_KEY = Key.create((String)"internal vcs operation");
    public static final TObjectHashingStrategy<FilePath> CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY = new TObjectHashingStrategy<FilePath>(){

        public int computeHashCode(@Nullable FilePath path2) {
            return path2 != null ? Objects.hash(path2.getPath(), path2.isDirectory()) : 0;
        }

        public boolean equals(@Nullable FilePath path1, @Nullable FilePath path2) {
            if (path1 == path2) {
                return true;
            }
            if (path1 == null || path2 == null) {
                return false;
            }
            return path1.isDirectory() == path2.isDirectory() && path1.getPath().equals(path2.getPath());
        }
    };

    private ChangesUtil() {
    }

    @NotNull
    public static FilePath getFilePath(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "getFilePath"));
        }
        ContentRevision revision = change.getAfterRevision();
        if (revision == null) {
            revision = change.getBeforeRevision();
            assert (revision != null);
        }
        FilePath filePath2 = revision.getFile();
        if (filePath2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getFilePath"));
        }
        return filePath2;
    }

    @Nullable
    public static FilePath getBeforePath(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "getBeforePath"));
        }
        ContentRevision revision = change.getBeforeRevision();
        return revision == null ? null : revision.getFile();
    }

    @Nullable
    public static FilePath getAfterPath(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "getAfterPath"));
        }
        ContentRevision revision = change.getAfterRevision();
        return revision == null ? null : revision.getFile();
    }

    @Nullable
    public static AbstractVcs getVcsForChange(@NotNull Change change, @NotNull Project project) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "getVcsForChange"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getVcsForChange"));
        }
        AbstractVcs result = ChangeListManager.getInstance(project).getVcsFor(change);
        return result != null ? result : ProjectLevelVcsManager.getInstance(project).getVcsFor(ChangesUtil.getFilePath(change));
    }

    @NotNull
    public static Set<AbstractVcs> getAffectedVcses(@NotNull Collection<Change> changes, @NotNull Project project) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "getAffectedVcses"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getAffectedVcses"));
        }
        Set set = ContainerUtil.map2SetNotNull(changes, change -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "lambda$getAffectedVcses$0"));
            }
            return ChangesUtil.getVcsForChange(change, project);
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getAffectedVcses"));
        }
        return set;
    }

    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangesUtil", "getVcsForFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getVcsForFile"));
        }
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(file);
    }

    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull File file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangesUtil", "getVcsForFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getVcsForFile"));
        }
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(VcsUtil.getFilePath(file));
    }

    @NotNull
    public static List<FilePath> getPaths(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPaths"));
        }
        List<FilePath> list = ChangesUtil.getPaths(changes.stream()).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPaths"));
        }
        return list;
    }

    @NotNull
    public static List<File> getIoFilesFromChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "getIoFilesFromChanges"));
        }
        List<File> list = ChangesUtil.getPaths(changes.stream()).map(FilePath::getIOFile).distinct().collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getIoFilesFromChanges"));
        }
        return list;
    }

    @NotNull
    public static Stream<FilePath> getPaths(@NotNull Stream<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPaths"));
        }
        Stream<FilePath> stream = changes.flatMap(ChangesUtil::getPathsCaseSensitive);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPaths"));
        }
        return stream;
    }

    @NotNull
    public static Stream<FilePath> getPathsCaseSensitive(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPathsCaseSensitive"));
        }
        FilePath beforePath = ChangesUtil.getBeforePath(change);
        FilePath afterPath = ChangesUtil.getAfterPath(change);
        Stream<FilePath> stream = Stream.of(beforePath, !CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)beforePath, (Object)afterPath) ? afterPath : null).filter(Objects::nonNull);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getPathsCaseSensitive"));
        }
        return stream;
    }

    @NotNull
    public static Stream<VirtualFile> getFiles(@NotNull Stream<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "getFiles"));
        }
        Stream<VirtualFile> stream = ChangesUtil.getPaths(changes).map(FilePath::getVirtualFile).filter(Objects::nonNull);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getFiles"));
        }
        return stream;
    }

    @Deprecated
    @NotNull
    public static VirtualFile[] getFilesFromChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "getFilesFromChanges"));
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ChangesUtil.getFiles(changes.stream()).toArray(VirtualFile[]::new);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getFilesFromChanges"));
        }
        return virtualFileArray;
    }

    @NotNull
    public static Navigatable[] getNavigatableArray(@NotNull Project project, @NotNull VirtualFile[] files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getNavigatableArray"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangesUtil", "getNavigatableArray"));
        }
        Navigatable[] navigatableArray = ChangesUtil.getNavigatableArray(project, Stream.of(files));
        if (navigatableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getNavigatableArray"));
        }
        return navigatableArray;
    }

    @NotNull
    public static Navigatable[] getNavigatableArray(@NotNull Project project, @NotNull Stream<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getNavigatableArray"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangesUtil", "getNavigatableArray"));
        }
        Navigatable[] navigatableArray = (Navigatable[])files.filter(file -> !file.isDirectory()).map(file -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "lambda$getNavigatableArray$3"));
            }
            return new OpenFileDescriptor(project, (VirtualFile)file);
        }).toArray(Navigatable[]::new);
        if (navigatableArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "getNavigatableArray"));
        }
        return navigatableArray;
    }

    @Nullable
    public static ChangeList getChangeListIfOnlyOne(@NotNull Project project, @Nullable Change[] changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getChangeListIfOnlyOne"));
        }
        ChangeListManager manager = ChangeListManager.getInstance(project);
        String changeListName = manager.getChangeListNameIfOnlyOne(changes);
        return changeListName == null ? null : manager.findChangeList(changeListName);
    }

    public static FilePath getCommittedPath(@NotNull Project project, FilePath filePath2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getCommittedPath"));
        }
        Change change = ChangeListManager.getInstance(project).getChange(filePath2);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && afterRevision.getFile().equals(filePath2)) {
                filePath2 = beforeRevision.getFile();
            }
        }
        return filePath2;
    }

    public static FilePath getLocalPath(@NotNull Project project, FilePath filePath2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getLocalPath"));
        }
        Change change = (Change)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "lambda$getLocalPath$5"));
            }
            if (project.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return ChangeListManager.getInstance(project).getChange(filePath2);
        });
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && beforeRevision.getFile().equals(filePath2)) {
                return afterRevision.getFile();
            }
        }
        return filePath2;
    }

    @Nullable
    public static VirtualFile findValidParentUnderReadAction(@NotNull FilePath path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/ChangesUtil", "findValidParentUnderReadAction"));
        }
        VirtualFile file = path2.getVirtualFile();
        return file != null ? file : ChangesUtil.getValidParentUnderReadAction(path2);
    }

    @Nullable
    public static VirtualFile findValidParentAccurately(@NotNull FilePath filePath2) {
        if (filePath2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/ChangesUtil", "findValidParentAccurately"));
        }
        VirtualFile result = filePath2.getVirtualFile();
        if (result == null && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            result = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath2.getPath());
        }
        if (result == null) {
            result = ChangesUtil.getValidParentUnderReadAction(filePath2);
        }
        return result;
    }

    @Nullable
    private static VirtualFile getValidParentUnderReadAction(@NotNull FilePath filePath2) {
        if (filePath2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/ChangesUtil", "getValidParentUnderReadAction"));
        }
        return (VirtualFile)ReadAction.compute(() -> {
            if (filePath2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/changes/ChangesUtil", "lambda$getValidParentUnderReadAction$6"));
            }
            VirtualFile result = null;
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            for (FilePath parent = filePath2; result == null && parent != null; parent = parent.getParentPath()) {
                result = lfs.findFileByPath(parent.getPath());
            }
            return result;
        });
    }

    @Nullable
    public static String getProjectRelativePath(@NotNull Project project, @Nullable File fileName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "getProjectRelativePath"));
        }
        if (fileName == null) {
            return null;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return fileName.toString();
        }
        String relativePath = FileUtil.getRelativePath((File)VfsUtilCore.virtualToIoFile(baseDir), (File)fileName);
        if (relativePath != null) {
            return relativePath;
        }
        return fileName.toString();
    }

    public static boolean isBinaryContentRevision(@Nullable ContentRevision revision) {
        return revision instanceof BinaryContentRevision && !revision.getFile().isDirectory();
    }

    public static boolean isBinaryChange(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "isBinaryChange"));
        }
        return ChangesUtil.isBinaryContentRevision(change.getBeforeRevision()) || ChangesUtil.isBinaryContentRevision(change.getAfterRevision());
    }

    public static boolean isTextConflictingChange(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "isTextConflictingChange"));
        }
        FileStatus status = change.getFileStatus();
        return FileStatus.MERGED_WITH_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status);
    }

    public static <T> void processItemsByVcs(@NotNull Collection<T> items, @NotNull VcsSeparator<T> separator, @NotNull PerVcsProcessor<T> processor) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ChangesUtil", "processItemsByVcs"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/vcs/changes/ChangesUtil", "processItemsByVcs"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vcs/changes/ChangesUtil", "processItemsByVcs"));
        }
        Map changesByVcs = (Map)ReadAction.compute(() -> {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/vcs/changes/ChangesUtil", "lambda$processItemsByVcs$7"));
            }
            if (separator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/vcs/changes/ChangesUtil", "lambda$processItemsByVcs$7"));
            }
            return StreamEx.of((Collection)items).mapToEntry(separator::getVcsFor, Function.identity()).nonNullKeys().grouping();
        });
        changesByVcs.forEach(processor::process);
    }

    public static void processChangesByVcs(@NotNull Project project, @NotNull Collection<Change> changes, @NotNull PerVcsProcessor<Change> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "processChangesByVcs"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "processChangesByVcs"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vcs/changes/ChangesUtil", "processChangesByVcs"));
        }
        ChangesUtil.processItemsByVcs(changes, change -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "lambda$processChangesByVcs$8"));
            }
            return ChangesUtil.getVcsForChange(change, project);
        }, processor);
    }

    public static void processVirtualFilesByVcs(@NotNull Project project, @NotNull Collection<VirtualFile> files, @NotNull PerVcsProcessor<VirtualFile> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "processVirtualFilesByVcs"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangesUtil", "processVirtualFilesByVcs"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vcs/changes/ChangesUtil", "processVirtualFilesByVcs"));
        }
        ChangesUtil.processItemsByVcs(files, file -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "lambda$processVirtualFilesByVcs$9"));
            }
            return ChangesUtil.getVcsForFile(file, project);
        }, processor);
    }

    public static void processFilePathsByVcs(@NotNull Project project, @NotNull Collection<FilePath> files, @NotNull PerVcsProcessor<FilePath> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "processFilePathsByVcs"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ChangesUtil", "processFilePathsByVcs"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/vcs/changes/ChangesUtil", "processFilePathsByVcs"));
        }
        ChangesUtil.processItemsByVcs(files, filePath2 -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesUtil", "lambda$processFilePathsByVcs$10"));
            }
            return ChangesUtil.getVcsForFile(filePath2.getIOFile(), project);
        }, processor);
    }

    @NotNull
    public static List<File> filePathsToFiles(@NotNull Collection<FilePath> filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/openapi/vcs/changes/ChangesUtil", "filePathsToFiles"));
        }
        List<File> list = filePaths.stream().map(FilePath::getIOFile).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ChangesUtil", "filePathsToFiles"));
        }
        return list;
    }

    public static boolean hasFileChanges(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "hasFileChanges"));
        }
        return changes.stream().map(ChangesUtil::getFilePath).anyMatch(path2 -> !path2.isDirectory());
    }

    public static void markInternalOperation(@NotNull Iterable<Change> changes, boolean set) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "markInternalOperation"));
        }
        for (Change change : changes) {
            VirtualFile file = change.getVirtualFile();
            if (file == null) continue;
            ChangesUtil.markInternalOperation(file, set);
        }
    }

    public static void markInternalOperation(@NotNull VirtualFile file, boolean set) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangesUtil", "markInternalOperation"));
        }
        file.putUserData(INTERNAL_OPERATION_KEY, set);
    }

    public static boolean isInternalOperation(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/ChangesUtil", "isInternalOperation"));
        }
        return Boolean.TRUE.equals(file.getUserData(INTERNAL_OPERATION_KEY));
    }

    @Nullable
    public static File findCommonAncestor(@NotNull Collection<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ChangesUtil", "findCommonAncestor"));
        }
        File ancestor = null;
        for (Change change : changes) {
            File currentChangeAncestor = ChangesUtil.getCommonBeforeAfterAncestor(change);
            if (currentChangeAncestor == null) {
                return null;
            }
            if (ancestor == null) {
                ancestor = currentChangeAncestor;
                continue;
            }
            if ((ancestor = FileUtil.findAncestor((File)ancestor, (File)currentChangeAncestor)) != null) continue;
            return null;
        }
        return ancestor;
    }

    @Nullable
    private static File getCommonBeforeAfterAncestor(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/changes/ChangesUtil", "getCommonBeforeAfterAncestor"));
        }
        FilePath before = ChangesUtil.getBeforePath(change);
        FilePath after = ChangesUtil.getAfterPath(change);
        return before == null ? ((FilePath)ObjectUtils.assertNotNull((Object)after)).getIOFile() : (after == null ? before.getIOFile() : FileUtil.findAncestor((File)before.getIOFile(), (File)after.getIOFile()));
    }

    @FunctionalInterface
    public static interface VcsSeparator<T> {
        @Nullable
        public AbstractVcs getVcsFor(@NotNull T var1);
    }

    @FunctionalInterface
    public static interface PerVcsProcessor<T> {
        public void process(@NotNull AbstractVcs var1, @NotNull List<T> var2);
    }
}

