/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.EventListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxTreeBase
extends Tree {
    private final CheckboxTreeHelper myHelper;
    private final EventDispatcher<CheckboxTreeListener> myEventDispatcher = EventDispatcher.create(CheckboxTreeListener.class);

    public CheckboxTreeBase() {
        this(new CheckboxTreeCellRendererBase(), null);
    }

    public CheckboxTreeBase(CheckboxTreeCellRendererBase cellRenderer, CheckedTreeNode root) {
        this(cellRenderer, root, CheckboxTreeHelper.DEFAULT_POLICY);
    }

    public CheckboxTreeBase(CheckboxTreeCellRendererBase cellRenderer, @Nullable CheckedTreeNode root, CheckPolicy checkPolicy) {
        this.myHelper = new CheckboxTreeHelper(checkPolicy, this.myEventDispatcher);
        if (root != null) {
            this.setModel(new DefaultTreeModel(root));
            this.setSelectionRow(0);
        }
        this.myEventDispatcher.addListener((EventListener)new CheckboxTreeListener(){

            @Override
            public void mouseDoubleClicked(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/CheckboxTreeBase$1", "mouseDoubleClicked"));
                }
                CheckboxTreeBase.this.onDoubleClick(node);
            }

            @Override
            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/CheckboxTreeBase$1", "nodeStateChanged"));
                }
                CheckboxTreeBase.this.onNodeStateChanged(node);
            }

            @Override
            public void beforeNodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/CheckboxTreeBase$1", "beforeNodeStateChanged"));
                }
                CheckboxTreeBase.this.nodeStateWillChange(node);
            }
        });
        this.myHelper.initTree(this, this, cellRenderer);
    }

    @Deprecated
    public void installRenderer(CheckboxTreeCellRendererBase cellRenderer) {
        this.setCellRenderer(cellRenderer);
    }

    @Deprecated
    protected boolean toggleNode(CheckedTreeNode node) {
        this.setNodeState(node, !node.isChecked());
        return node.isChecked();
    }

    @Deprecated
    protected void checkNode(CheckedTreeNode node, boolean checked) {
        this.setNodeState(node, checked);
    }

    public void setNodeState(@NotNull CheckedTreeNode node, boolean checked) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/CheckboxTreeBase", "setNodeState"));
        }
        this.myHelper.setNodeState(this, node, checked);
    }

    public void addCheckboxTreeListener(@NotNull CheckboxTreeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/CheckboxTreeBase", "addCheckboxTreeListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    protected void onDoubleClick(CheckedTreeNode node) {
    }

    public <T> T[] getCheckedNodes(Class<T> nodeType, @Nullable Tree.NodeFilter<T> filter) {
        return CheckboxTreeHelper.getCheckedNodes(nodeType, filter, this.getModel());
    }

    @Override
    public int getToggleClickCount() {
        return -1;
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
    }

    protected void nodeStateWillChange(CheckedTreeNode node) {
    }

    @Deprecated
    protected void adjustParents(CheckedTreeNode node, boolean checked) {
    }

    public static class CheckPolicy {
        final boolean checkChildrenWithCheckedParent;
        final boolean uncheckChildrenWithUncheckedParent;
        final boolean checkParentWithCheckedChild;
        final boolean uncheckParentWithUncheckedChild;

        public CheckPolicy(boolean checkChildrenWithCheckedParent, boolean uncheckChildrenWithUncheckedParent, boolean checkParentWithCheckedChild, boolean uncheckParentWithUncheckedChild) {
            this.checkChildrenWithCheckedParent = checkChildrenWithCheckedParent;
            this.uncheckChildrenWithUncheckedParent = uncheckChildrenWithUncheckedParent;
            this.checkParentWithCheckedChild = checkParentWithCheckedChild;
            this.uncheckParentWithUncheckedChild = uncheckParentWithUncheckedChild;
        }
    }

    public static enum NodeState {
        FULL,
        CLEAR,
        PARTIAL;

    }

    public static class CheckboxTreeCellRendererBase
    extends JPanel
    implements TreeCellRenderer {
        private final ColoredTreeCellRenderer myTextRenderer;
        public final ThreeStateCheckBox myCheckbox;
        private final boolean myUsePartialStatusForParentNodes;
        protected boolean myIgnoreInheritance;

        public CheckboxTreeCellRendererBase(boolean opaque) {
            this(opaque, true);
        }

        public CheckboxTreeCellRendererBase(boolean opaque, boolean usePartialStatusForParentNodes) {
            super(new BorderLayout());
            this.myUsePartialStatusForParentNodes = usePartialStatusForParentNodes;
            this.myCheckbox = new ThreeStateCheckBox();
            this.myCheckbox.setSelected(false);
            this.myCheckbox.setThirdStateEnabled(false);
            this.myTextRenderer = new ColoredTreeCellRenderer(){

                @Override
                public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (tree == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ui/CheckboxTreeBase$CheckboxTreeCellRendererBase$1", "customizeCellRenderer"));
                    }
                }
            };
            this.myTextRenderer.setOpaque(opaque);
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)this.myTextRenderer, "Center");
        }

        public CheckboxTreeCellRendererBase() {
            this(true);
        }

        @Override
        public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.invalidate();
            if (value instanceof CheckedTreeNode) {
                CheckedTreeNode node = (CheckedTreeNode)value;
                NodeState state = this.getNodeStatus(node);
                this.myCheckbox.setVisible(true);
                this.myCheckbox.setSelected(state != NodeState.CLEAR);
                this.myCheckbox.setEnabled(node.isEnabled() && state != NodeState.PARTIAL);
                this.myCheckbox.setOpaque(false);
                this.myCheckbox.setBackground(null);
                this.setBackground(null);
                if (UIUtil.isUnderWin10LookAndFeel()) {
                    Object hoverValue = this.getClientProperty("JCheckBox.rollOver.rectangle");
                    this.myCheckbox.getModel().setRollover(hoverValue == value);
                    Object pressedValue = this.getClientProperty("JCheckBox.pressed.rectangle");
                    this.myCheckbox.getModel().setPressed(pressedValue == value);
                }
            } else {
                this.myCheckbox.setVisible(false);
            }
            this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                UIUtil.changeBackGround((Component)this, (Color)background);
            } else if (UIUtil.isUnderNimbusLookAndFeel()) {
                UIUtil.changeBackGround((Component)this, (Color)UIUtil.TRANSPARENT_COLOR);
            }
            this.customizeRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
            this.revalidate();
            return this;
        }

        private NodeState getNodeStatus(CheckedTreeNode node) {
            if (this.myIgnoreInheritance) {
                return node.isChecked() ? NodeState.FULL : NodeState.CLEAR;
            }
            boolean checked = node.isChecked();
            if (node.getChildCount() == 0 || !this.myUsePartialStatusForParentNodes) {
                return checked ? NodeState.FULL : NodeState.CLEAR;
            }
            NodeState result = null;
            for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                NodeState childStatus;
                TreeNode child = node.getChildAt(i2);
                NodeState nodeState = child instanceof CheckedTreeNode ? this.getNodeStatus((CheckedTreeNode)child) : (childStatus = checked ? NodeState.FULL : NodeState.CLEAR);
                if (childStatus == NodeState.PARTIAL) {
                    return NodeState.PARTIAL;
                }
                if (result == null) {
                    result = childStatus;
                    continue;
                }
                if (result == childStatus) continue;
                return NodeState.PARTIAL;
            }
            return result == null ? NodeState.CLEAR : result;
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof CheckedTreeNode) {
                this.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
            }
        }

        @Deprecated
        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        }

        public ColoredTreeCellRenderer getTextRenderer() {
            return this.myTextRenderer;
        }

        public JCheckBox getCheckbox() {
            return this.myCheckbox;
        }
    }
}

