/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.UsageGroupBase;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleGroupingRule
implements UsageGroupingRule,
DumbAware {
    private final ModuleGrouper myGrouper;
    private final boolean myFlattenModules;

    public ModuleGroupingRule(Project project, boolean flattenModules) {
        this.myGrouper = ModuleGrouper.instanceFor(project);
        this.myFlattenModules = flattenModules;
    }

    @Override
    @NotNull
    public List<UsageGroup> getParentGroupsFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        UsageInLibrary usageInLibrary;
        OrderEntry entry;
        UsageInModule usageInModule;
        Module module;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/rules/ModuleGroupingRule", "getParentGroupsFor"));
        }
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/rules/ModuleGroupingRule", "getParentGroupsFor"));
        }
        if (usage instanceof UsageInModule && (module = (usageInModule = (UsageInModule)usage).getModule()) != null) {
            if (this.myFlattenModules) {
                List<UsageGroup> list = Collections.singletonList(new ModuleUsageGroup(module, null));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/ModuleGroupingRule", "getParentGroupsFor"));
                }
                return list;
            }
            List<String> groupPath = this.myGrouper.getGroupPath(module);
            ArrayList<UsageGroup> parentGroups = new ArrayList<UsageGroup>(groupPath.size() + 1);
            for (int i2 = 1; i2 <= groupPath.size(); ++i2) {
                parentGroups.add(new ModuleGroupUsageGroup(groupPath.subList(0, i2)));
            }
            parentGroups.add(new ModuleUsageGroup(module, this.myGrouper));
            ArrayList<UsageGroup> arrayList = parentGroups;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/ModuleGroupingRule", "getParentGroupsFor"));
            }
            return arrayList;
        }
        if (usage instanceof UsageInLibrary && (entry = (usageInLibrary = (UsageInLibrary)usage).getLibraryEntry()) != null) {
            List<UsageGroup> list = Collections.singletonList(new LibraryUsageGroup(entry));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/ModuleGroupingRule", "getParentGroupsFor"));
            }
            return list;
        }
        List<UsageGroup> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/ModuleGroupingRule", "getParentGroupsFor"));
        }
        return list;
    }

    private static class ModuleGroupUsageGroup
    extends UsageGroupBase {
        private final List<String> myGroupPath;

        public ModuleGroupUsageGroup(@NotNull List<String> groupPath) {
            if (groupPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPath", "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleGroupUsageGroup", "<init>"));
            }
            super(0);
            this.myGroupPath = groupPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof ModuleGroupUsageGroup && this.myGroupPath.equals(((ModuleGroupUsageGroup)o).myGroupPath);
        }

        public int hashCode() {
            return this.myGroupPath.hashCode();
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return AllIcons.Nodes.ModuleGroup;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myGroupPath.get(this.myGroupPath.size() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleGroupUsageGroup", "getText"));
            }
            return string;
        }

        public String toString() {
            return UsageViewBundle.message("node.group.module.group", new Object[0]) + this.getText(null);
        }
    }

    private static class ModuleUsageGroup
    extends UsageGroupBase
    implements TypeSafeDataProvider {
        private final Module myModule;
        private final ModuleGrouper myGrouper;

        public ModuleUsageGroup(@NotNull Module module, @Nullable ModuleGrouper grouper) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup", "<init>"));
            }
            super(1);
            this.myModule = module;
            this.myGrouper = grouper;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModuleUsageGroup)) {
                return false;
            }
            ModuleUsageGroup moduleUsageGroup = (ModuleUsageGroup)o;
            return this.myModule.equals(moduleUsageGroup.myModule);
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.myModule.isDisposed() ? null : ModuleType.get(this.myModule).getIcon();
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myModule.isDisposed() ? "" : (this.myGrouper != null ? this.myGrouper.getShortenedName(this.myModule) : this.myModule.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup", "getText"));
            }
            return string;
        }

        @Override
        public boolean isValid() {
            return !this.myModule.isDisposed();
        }

        public String toString() {
            return UsageViewBundle.message("node.group.module", new Object[0]) + this.getText(null);
        }

        @Override
        public void calcData(DataKey key, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (LangDataKeys.MODULE_CONTEXT == key) {
                sink.put(LangDataKeys.MODULE_CONTEXT, this.myModule);
            }
        }
    }

    private static class LibraryUsageGroup
    extends UsageGroupBase {
        private final OrderEntry myEntry;

        @Override
        public void update() {
        }

        public LibraryUsageGroup(@NotNull OrderEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup", "<init>"));
            }
            super(2);
            this.myEntry = entry;
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return AllIcons.Nodes.PpLibFolder;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myEntry.getPresentableName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup", "getText"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof LibraryUsageGroup && this.myEntry.equals(((LibraryUsageGroup)o).myEntry);
        }

        public int hashCode() {
            return this.myEntry.hashCode();
        }
    }
}

