/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UnknownUsagesInUnloadedModules;
import com.intellij.usages.impl.rules.UsageGroupBase;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.usages.rules.UsageInFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonCodeUsageGroupingRule
extends SingleParentUsageGroupingRule {
    private final Project myProject;

    public NonCodeUsageGroupingRule(Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        VirtualFile file;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule", "getParentGroupFor"));
        }
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule", "getParentGroupFor"));
        }
        if (usage instanceof UnknownUsagesInUnloadedModules) {
            return UnloadedModulesUsageGroup.INSTANCE;
        }
        if (usage instanceof UsageInFile && (file = ((UsageInFile)usage).getFile()) != null && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file, this.myProject)) {
            return UsageInGeneratedCodeGroup.INSTANCE;
        }
        if (usage instanceof PsiElementUsage) {
            UsageInfo usageInfo;
            if (usage instanceof UsageInfo2UsageAdapter && (usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo()).isDynamicUsage()) {
                return DynamicUsageGroup.INSTANCE;
            }
            if (((PsiElementUsage)usage).isNonCodeUsage()) {
                return NonCodeUsageGroup.INSTANCE;
            }
            return CodeUsageGroup.INSTANCE;
        }
        return null;
    }

    private static class UnloadedModulesUsageGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new UnloadedModulesUsageGroup();

        public UnloadedModulesUsageGroup() {
            super(0);
        }

        @Override
        @NotNull
        public String getText(@Nullable UsageView view) {
            if ("Usages in Unloaded Modules" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$UnloadedModulesUsageGroup", "getText"));
            }
            return "Usages in Unloaded Modules";
        }

        public String toString() {
            return this.getText(null);
        }
    }

    private static class DynamicUsageGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new DynamicUsageGroup();
        @NonNls
        private static final String DYNAMIC_CAPTION = "Dynamic usages";

        public DynamicUsageGroup() {
            super(2);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            if (view == null) {
                if (DYNAMIC_CAPTION == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$DynamicUsageGroup", "getText"));
                }
                return DYNAMIC_CAPTION;
            }
            String dynamicCodeUsagesString = view.getPresentation().getDynamicCodeUsagesString();
            String string = dynamicCodeUsagesString == null ? DYNAMIC_CAPTION : dynamicCodeUsagesString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$DynamicUsageGroup", "getText"));
            }
            return string;
        }

        public String toString() {
            return "DynamicUsages";
        }
    }

    private static class NonCodeUsageGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new NonCodeUsageGroup();

        private NonCodeUsageGroup() {
            super(3);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = view == null ? UsageViewBundle.message("node.non.code.usages", new Object[0]) : view.getPresentation().getNonCodeUsagesString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$NonCodeUsageGroup", "getText"));
            }
            return string;
        }

        @Override
        public void update() {
        }

        public String toString() {
            return "NonCodeUsages";
        }
    }

    private static class UsageInGeneratedCodeGroup
    extends UsageGroupBase {
        public static final UsageGroup INSTANCE = new UsageInGeneratedCodeGroup();

        private UsageInGeneratedCodeGroup() {
            super(4);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = view == null ? UsageViewBundle.message("node.usages.in.generated.code", new Object[0]) : view.getPresentation().getUsagesInGeneratedCodeString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$UsageInGeneratedCodeGroup", "getText"));
            }
            return string;
        }

        public String toString() {
            return "UsagesInGeneratedCode";
        }
    }

    private static class CodeUsageGroup
    extends UsageGroupBase {
        private static final UsageGroup INSTANCE = new CodeUsageGroup();

        private CodeUsageGroup() {
            super(1);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = view == null ? UsageViewBundle.message("node.group.code.usages", new Object[0]) : view.getPresentation().getCodeUsagesString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$CodeUsageGroup", "getText"));
            }
            return string;
        }

        public String toString() {
            return "CodeUsages";
        }
    }
}

