/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.ReadWriteAccessUsage;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.usages.impl.rules.UsageTypeProviderEx;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageTypeGroupingRule
extends SingleParentUsageGroupingRule {
    @Override
    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/rules/UsageTypeGroupingRule", "getParentGroupFor"));
        }
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/rules/UsageTypeGroupingRule", "getParentGroupFor"));
        }
        if (usage instanceof PsiElementUsage) {
            PsiElementUsage elementUsage = (PsiElementUsage)usage;
            PsiElement element = elementUsage.getElement();
            UsageType usageType = UsageTypeGroupingRule.getUsageType(element, targets);
            if (usageType == null && element instanceof PsiFile && elementUsage instanceof UsageInfo2UsageAdapter) {
                usageType = ((UsageInfo2UsageAdapter)elementUsage).getUsageType();
            }
            if (usageType != null) {
                return new UsageTypeGroup(usageType);
            }
            if (usage instanceof ReadWriteAccessUsage) {
                ReadWriteAccessUsage u = (ReadWriteAccessUsage)usage;
                if (u.isAccessedForWriting()) {
                    return new UsageTypeGroup(UsageType.WRITE);
                }
                if (u.isAccessedForReading()) {
                    return new UsageTypeGroup(UsageType.READ);
                }
            }
            return new UsageTypeGroup(UsageType.UNCLASSIFIED);
        }
        return null;
    }

    @Nullable
    private static UsageType getUsageType(PsiElement element, @NotNull UsageTarget[] targets) {
        UsageTypeProvider[] providers;
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/rules/UsageTypeGroupingRule", "getUsageType"));
        }
        if (element == null) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType(element, PsiComment.class, false) != null) {
            return UsageType.COMMENT_USAGE;
        }
        for (UsageTypeProvider provider : providers = (UsageTypeProvider[])Extensions.getExtensions(UsageTypeProvider.EP_NAME)) {
            UsageType usageType = provider instanceof UsageTypeProviderEx ? ((UsageTypeProviderEx)provider).getUsageType(element, targets) : provider.getUsageType(element);
            if (usageType == null) continue;
            return usageType;
        }
        return null;
    }

    private static class UsageTypeGroup
    implements UsageGroup {
        private final UsageType myUsageType;

        private UsageTypeGroup(@NotNull UsageType usageType) {
            if (usageType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageType", "com/intellij/usages/impl/rules/UsageTypeGroupingRule$UsageTypeGroup", "<init>"));
            }
            this.myUsageType = usageType;
        }

        @Override
        public void update() {
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return null;
        }

        @Override
        @NotNull
        public String getText(@Nullable UsageView view) {
            String string = view == null ? this.myUsageType.toString() : this.myUsageType.toString(view.getPresentation());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/UsageTypeGroupingRule$UsageTypeGroup", "getText"));
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return null;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void navigate(boolean focus) {
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageGroup", "com/intellij/usages/impl/rules/UsageTypeGroupingRule$UsageTypeGroup", "compareTo"));
            }
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UsageTypeGroup)) {
                return false;
            }
            UsageTypeGroup usageTypeGroup = (UsageTypeGroup)o;
            return this.myUsageType.equals(usageTypeGroup.myUsageType);
        }

        public int hashCode() {
            return this.myUsageType.hashCode();
        }

        public String toString() {
            return "Type:" + this.myUsageType.toString(new UsageViewPresentation());
        }
    }
}

