/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import com.intellij.junit5.JUnit5TestExecutionListener;
import com.intellij.junit5.JUnit5TestRunnerUtil;
import com.intellij.rt.execution.junit.IDEAJUnitListener;
import com.intellij.rt.execution.junit.IDEAJUnitListenerEx;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnit5IdeaTestRunner
implements IdeaTestRunner {
    private TestPlan myTestPlan;
    private JUnit5TestExecutionListener myListener;
    private ArrayList myListeners;
    private Launcher myLauncher;

    public void createListeners(ArrayList listeners) {
        this.myListeners = listeners;
        this.myListener = new JUnit5TestExecutionListener();
        this.myLauncher = LauncherFactory.create();
    }

    public int startRunnerWithArgs(String[] args, String name, int count, boolean sendTree) {
        try {
            this.myListener.initialize();
            String[] packageNameRef = new String[1];
            LauncherDiscoveryRequest discoveryRequest = JUnit5TestRunnerUtil.buildRequest(args, packageNameRef);
            this.myTestPlan = this.myLauncher.discover(discoveryRequest);
            ArrayList<Object> listeners = new ArrayList<Object>();
            listeners.add(this.myListener);
            for (Object listenerClassName : this.myListeners) {
                IDEAJUnitListener junitListener = (IDEAJUnitListener)Class.forName((String)listenerClassName).newInstance();
                listeners.add(new MyCustomListenerWrapper(junitListener));
            }
            if (sendTree) {
                do {
                    this.myListener.sendTree(this.myTestPlan, packageNameRef[0]);
                } while (--count > 0);
            }
            this.myLauncher.execute(discoveryRequest, listeners.toArray(new TestExecutionListener[0]));
            return this.myListener.wasSuccessful() ? 0 : -1;
        }
        catch (Exception e) {
            System.err.println("Internal Error occurred.");
            e.printStackTrace(System.err);
            return -2;
        }
    }

    public Object getTestToStart(String[] args, String name) {
        LauncherDiscoveryRequest discoveryRequest = JUnit5TestRunnerUtil.buildRequest(args, new String[1]);
        Launcher launcher = LauncherFactory.create();
        this.myTestPlan = launcher.discover(discoveryRequest);
        Set roots = this.myTestPlan.getRoots();
        return roots.isEmpty() ? null : roots.iterator().next();
    }

    public List getChildTests(Object description) {
        return new ArrayList(this.myTestPlan.getChildren((TestIdentifier)description));
    }

    public String getStartDescription(Object child) {
        TestIdentifier testIdentifier = (TestIdentifier)child;
        String className = JUnit5TestExecutionListener.getClassName(testIdentifier);
        String methodSignature = JUnit5TestExecutionListener.getMethodSignature(testIdentifier);
        if (methodSignature != null) {
            return className + "," + methodSignature;
        }
        return className != null ? className : testIdentifier.getDisplayName();
    }

    public String getTestClassName(Object child) {
        return child.toString();
    }

    private static class MyCustomListenerWrapper
    implements TestExecutionListener {
        private final IDEAJUnitListener myJunitListener;

        public MyCustomListenerWrapper(IDEAJUnitListener junitListener) {
            this.myJunitListener = junitListener;
        }

        public void executionStarted(TestIdentifier testIdentifier) {
            if (testIdentifier.isTest()) {
                String className = JUnit5TestExecutionListener.getClassName(testIdentifier);
                String methodName = JUnit5TestExecutionListener.getMethodName(testIdentifier);
                this.myJunitListener.testStarted(className, methodName);
            }
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            if (testIdentifier.isTest()) {
                String className = JUnit5TestExecutionListener.getClassName(testIdentifier);
                String methodName = JUnit5TestExecutionListener.getMethodName(testIdentifier);
                if (this.myJunitListener instanceof IDEAJUnitListenerEx) {
                    ((IDEAJUnitListenerEx)this.myJunitListener).testFinished(className, methodName, testExecutionResult.getStatus() == TestExecutionResult.Status.SUCCESSFUL);
                } else {
                    this.myJunitListener.testFinished(className, methodName);
                }
            }
        }
    }
}

