/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class IconsReferencesContributor
extends PsiReferenceContributor
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/references/IconsReferencesContributor", "registerReferenceProviders"));
        }
        PsiJavaElementPattern.Capture presentationAnno = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().annotationParam("com.intellij.ide.presentation.Presentation", "icon");
        registrar.registerReferenceProvider((ElementPattern)presentationAnno, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1", "getReferencesByElement"));
                }
                if (!PsiUtil.isPluginProject(element.getProject())) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element, true){

                    public PsiElement resolve() {
                        List path;
                        String value = (String)((PsiLiteralExpression)element).getValue();
                        if (value != null && (path = StringUtil.split((String)value, (String)".")).size() > 1 && ((String)path.get(0)).endsWith("Icons")) {
                            Project project = element.getProject();
                            PsiClass cur = IconsReferencesContributor.findIconClass(project, (String)path.get(0));
                            if (cur == null) {
                                return null;
                            }
                            for (int i = 1; i < path.size() - 1; ++i) {
                                if ((cur = cur.findInnerClassByName((String)path.get(i), false)) != null) continue;
                                return null;
                            }
                            return cur.findFieldByName((String)path.get(path.size() - 1), false);
                        }
                        return null;
                    }

                    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                        PsiElement field = this.resolve();
                        if (field instanceof PsiField) {
                            String fqn = ((PsiField)field).getContainingClass().getQualifiedName();
                            if (fqn.startsWith("com.intellij.icons.")) {
                                return this.replace(newElementName, fqn, "com.intellij.icons.", element);
                            }
                            if (fqn.startsWith("icons.")) {
                                return this.replace(newElementName, fqn, "icons.", element);
                            }
                        }
                        return super.handleElementRename(newElementName);
                    }

                    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                        if (element2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1$1", "bindToElement"));
                        }
                        if (element2 instanceof PsiField) {
                            String fqn = ((PsiField)element2).getContainingClass().getQualifiedName();
                            String newElementName = ((PsiField)element2).getName();
                            if (fqn.startsWith("com.intellij.icons.")) {
                                return this.replace(newElementName, fqn, "com.intellij.icons.", this.getElement());
                            }
                            if (fqn.startsWith("icons.")) {
                                return this.replace(newElementName, fqn, "icons.", this.getElement());
                            }
                        }
                        return super.bindToElement(element2);
                    }

                    private PsiElement replace(String newElementName, String fqn, String pckg, PsiElement container) {
                        String newValue = "\"" + fqn.substring(pckg.length()) + "." + newElementName + "\"";
                        return this.getElement().replace((PsiElement)JavaPsiFacade.getElementFactory((Project)container.getProject()).createExpressionFromText(newValue, container.getParent()));
                    }

                    @NotNull
                    public Object[] getVariants() {
                        if (EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1$1", "getVariants"));
                        }
                        return EMPTY_ARRAY;
                    }
                }};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
        PsiMethodPattern method = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"findIcon", "getIcon"})).definedInClass(IconLoader.class.getName());
        PsiJavaElementPattern.Capture findGetIconPattern = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)method));
        registrar.registerReferenceProvider((ElementPattern)findGetIconPattern, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$2", "getReferencesByElement"));
                }
                if (!PsiUtil.isIdeaProject(element.getProject())) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$2", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                FileReference[] fileReferenceArray = new FileReferenceSet(element){

                    protected Collection<PsiFileSystemItem> getExtraContexts() {
                        Module icons = ModuleManager.getInstance((Project)element.getProject()).findModuleByName("icons");
                        if (icons != null) {
                            ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
                            VirtualFile[] roots = ModuleRootManager.getInstance((Module)icons).getSourceRoots();
                            PsiManager psiManager = element.getManager();
                            for (VirtualFile root : roots) {
                                PsiDirectory directory = psiManager.findDirectory(root);
                                if (directory == null) continue;
                                result.add((PsiFileSystemItem)directory);
                            }
                            return result;
                        }
                        return super.getExtraContexts();
                    }
                }.getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$2", "getReferencesByElement"));
                }
                return fileReferenceArray;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"icon"}), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$3", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$3", "getReferencesByElement"));
                }
                if (!PsiUtil.isPluginProject(element.getProject()) || !DescriptorUtil.isPluginXml(element.getContainingFile())) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$3", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element, true){

                    public PsiElement resolve() {
                        String value = ((XmlAttributeValue)element).getValue();
                        if (value.startsWith("/")) {
                            FileReference lastRef = new FileReferenceSet(element).getLastReference();
                            return lastRef != null ? lastRef.resolve() : null;
                        }
                        List path = StringUtil.split((String)value, (String)".");
                        if (path.size() > 1 && ((String)path.get(0)).endsWith("Icons")) {
                            Project project = element.getProject();
                            PsiClass cur = IconsReferencesContributor.findIconClass(project, (String)path.get(0));
                            if (cur == null) {
                                return null;
                            }
                            for (int i = 1; i < path.size() - 1; ++i) {
                                if ((cur = cur.findInnerClassByName((String)path.get(i), false)) != null) continue;
                                return null;
                            }
                            return cur.findFieldByName((String)path.get(path.size() - 1), false);
                        }
                        return null;
                    }

                    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                        PsiElement element2 = this.resolve();
                        if (element2 instanceof PsiFile) {
                            FileReference lastRef = new FileReferenceSet(element2).getLastReference();
                            return lastRef.handleElementRename(newElementName);
                        }
                        if (element2 instanceof PsiField) {
                            String fqn = ((PsiField)element2).getContainingClass().getQualifiedName();
                            if (fqn.startsWith("com.intellij.icons.")) {
                                return this.replace(fqn, newElementName, "com.intellij.icons.");
                            }
                            if (fqn.startsWith("icons.")) {
                                return this.replace(fqn, newElementName, "icons.");
                            }
                        }
                        return super.handleElementRename(newElementName);
                    }

                    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                        if (element2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$3$1", "bindToElement"));
                        }
                        if (element2 instanceof PsiFile) {
                            FileReference lastRef = new FileReferenceSet(element2).getLastReference();
                            return lastRef.bindToElement(element2);
                        }
                        if (element2 instanceof PsiField) {
                            String fqn = ((PsiField)element2).getContainingClass().getQualifiedName();
                            String newName = ((PsiField)element2).getName();
                            if (fqn.startsWith("com.intellij.icons.")) {
                                return this.replace(fqn, newName, "com.intellij.icons.");
                            }
                            if (fqn.startsWith("icons.")) {
                                return this.replace(fqn, newName, "icons.");
                            }
                        }
                        return super.bindToElement(element2);
                    }

                    private PsiElement replace(String fqn, String newName, String pckg) {
                        XmlAttribute parent = (XmlAttribute)this.getElement().getParent();
                        parent.setValue(fqn.substring(pckg.length()) + "." + newName);
                        return parent.getValueElement();
                    }

                    @NotNull
                    public Object[] getVariants() {
                        if (EMPTY_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$3$1", "getVariants"));
                        }
                        return EMPTY_ARRAY;
                    }
                }};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$3", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static PsiClass findIconClass(Project project, String className) {
        boolean isAllIcons = "AllIcons".equals(className);
        String fqnClassName = isAllIcons ? "com.intellij.icons.AllIcons" : "icons." + className;
        return JavaPsiFacade.getInstance((Project)project).findClass(fqnClassName, isAllIcons ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project));
    }

    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/idea/devkit/references/IconsReferencesContributor", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/devkit/references/IconsReferencesContributor", "execute"));
        }
        PsiElement file = queryParameters.getElementToSearch();
        if (file instanceof PsiBinaryFile) {
            Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
            VirtualFile image = ((PsiBinaryFile)file).getVirtualFile();
            if (IconsReferencesContributor.isImage(image) && IconsReferencesContributor.isIconsModule(module)) {
                Project project = file.getProject();
                FindModel model = new FindModel();
                String path = IconsReferencesContributor.getPathToImage(image, module);
                if (path == null) {
                    return true;
                }
                model.setStringToFind(path);
                model.setCaseSensitive(true);
                model.setFindAll(true);
                model.setWholeWordsOnly(true);
                FindInProjectUtil.findUsages((FindModel)model, (Project)project, usage -> {
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/devkit/references/IconsReferencesContributor", "lambda$execute$2"));
                    }
                    ApplicationManager.getApplication().runReadAction(() -> {
                        if (consumer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/devkit/references/IconsReferencesContributor", "lambda$null$1"));
                        }
                        PsiElement element = usage.getElement();
                        ProperTextRange textRange = usage.getRangeInElement();
                        if (element != null && textRange != null) {
                            PsiElement start = element.findElementAt(textRange.getStartOffset());
                            PsiElement end = element.findElementAt(textRange.getEndOffset());
                            if (start != null && end != null) {
                                PsiFileReference reference;
                                PsiElement value = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
                                if (value instanceof PsiJavaToken) {
                                    value = value.getParent();
                                }
                                if (value != null && (reference = FileReferenceUtil.findFileReference((PsiElement)value)) != null) {
                                    consumer.process((Object)reference);
                                }
                            }
                        }
                    });
                    return true;
                }, (FindUsagesProcessPresentation)new FindUsagesProcessPresentation(new UsageViewPresentation()));
            }
        }
        return true;
    }

    @Nullable
    private static String getPathToImage(VirtualFile image, Module module) {
        String path = ModuleRootManager.getInstance((Module)module).getSourceRoots()[0].getPath();
        return "/" + FileUtil.getRelativePath((String)path, (String)image.getPath(), (char)'/');
    }

    private static boolean isIconsModule(Module module) {
        return module != null && "icons".equals(module.getName()) && ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 1;
    }

    private static boolean isImage(VirtualFile image) {
        FileTypeManager mgr = FileTypeManager.getInstance();
        return image != null && mgr.getFileTypeByFile(image) == mgr.getFileTypeByExtension("png");
    }
}

