/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseDataReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorProcessHandler
extends ProcessHandler
implements TaskExecutor,
KillableProcess {
    private static final Logger LOG = Logger.getInstance(EmulatorProcessHandler.class);
    @NotNull
    private final Process myProcess;
    @NotNull
    private final GeneralCommandLine myCommandLine;

    public EmulatorProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/android/tools/idea/avdmanager/EmulatorProcessHandler", "<init>"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/android/tools/idea/avdmanager/EmulatorProcessHandler", "<init>"));
        }
        this.myProcess = process;
        this.myCommandLine = commandLine;
    }

    public void startNotify() {
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                try {
                    String presentableName = CommandLineUtil.extractPresentableName((String)EmulatorProcessHandler.this.myCommandLine.getCommandLineString());
                    EmulatorOutputReader stdoutReader = new EmulatorOutputReader(EmulatorProcessHandler.this.myProcess.getInputStream(), ProcessOutputTypes.STDOUT, presentableName);
                    EmulatorOutputReader stderrReader = new EmulatorOutputReader(EmulatorProcessHandler.this.myProcess.getErrorStream(), ProcessOutputTypes.STDERR, presentableName);
                    EmulatorProcessHandler.this.executeTask(() -> {
                        try {
                            stderrReader.waitFor();
                            stdoutReader.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            EmulatorProcessHandler.this.notifyProcessTerminated(0);
                        }
                    });
                }
                finally {
                    EmulatorProcessHandler.this.removeProcessListener((ProcessListener)this);
                }
            }
        });
        super.startNotify();
    }

    protected void destroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.notifyProcessTerminated(0);
        }
    }

    protected void detachProcessImpl() {
        Runnable runnable = () -> {
            this.closeStreams();
            this.notifyProcessDetached();
        };
        this.executeTask(runnable);
    }

    public boolean detachIsDefault() {
        return true;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return this.myProcess.getOutputStream();
    }

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    private void closeStreams() {
        try {
            this.myProcess.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public Future<?> executeTask(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/android/tools/idea/avdmanager/EmulatorProcessHandler", "executeTask"));
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(task);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/EmulatorProcessHandler", "executeTask"));
        }
        return future;
    }

    public boolean canKillProcess() {
        return false;
    }

    public void killProcess() {
    }

    private class EmulatorOutputReader
    extends BaseDataReader {
        private final BufferedReader myBufferedReader;
        private final Key myProcessOutputType;

        private EmulatorOutputReader(@NotNull InputStream stream, @NotNull Key processOutputType, String presentableName) {
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/android/tools/idea/avdmanager/EmulatorProcessHandler$EmulatorOutputReader", "<init>"));
            }
            if (processOutputType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutputType", "com/android/tools/idea/avdmanager/EmulatorProcessHandler$EmulatorOutputReader", "<init>"));
            }
            if (presentableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/android/tools/idea/avdmanager/EmulatorProcessHandler$EmulatorOutputReader", "<init>"));
            }
            super(BaseDataReader.SleepingPolicy.SIMPLE);
            this.myBufferedReader = new BufferedReader(new InputStreamReader(stream));
            this.myProcessOutputType = processOutputType;
            this.start(presentableName);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/avdmanager/EmulatorProcessHandler$EmulatorOutputReader", "executeOnPooledThread"));
            }
            Future<?> future = EmulatorProcessHandler.this.executeTask(runnable);
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/avdmanager/EmulatorProcessHandler$EmulatorOutputReader", "executeOnPooledThread"));
            }
            return future;
        }

        protected boolean readAvailable() throws IOException {
            String line = this.myBufferedReader.readLine();
            if (line == null) {
                this.stop();
                return false;
            }
            if (line.isEmpty()) {
                return false;
            }
            EmulatorProcessHandler.this.notifyTextAvailable(line + "\n", this.myProcessOutputType);
            return true;
        }

        protected void close() throws IOException {
            this.myBufferedReader.close();
        }
    }
}

