/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationMenuAction
extends FlatComboAction {
    private final EditorDesignSurface mySurface;
    private static final int ACTION_ADD = 1;
    private static final int ACTION_DELETE_ALL = 2;
    private static final int ACTION_PREVIEW_MODE = 3;

    public ConfigurationMenuAction(EditorDesignSurface surface) {
        this.mySurface = surface;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Layout Variants");
        presentation.setIcon(AndroidIcons.NeleIcons.Variants);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup("Configuration", true);
        Configuration configuration = this.mySurface.getConfiguration();
        if (configuration == null) {
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMenuAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }
        VirtualFile virtualFile = configuration.getFile();
        if (virtualFile != null) {
            ResourceFolderType folderType;
            Module module = configuration.getModule();
            if (module == null) {
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMenuAction", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }
            Project project = module.getProject();
            List<VirtualFile> variations = ResourceHelper.getResourceVariations(virtualFile, true);
            if (variations.size() > 1) {
                for (VirtualFile file : variations) {
                    String title = String.format("Switch to %1$s", file.getParent().getName());
                    group.add((AnAction)new SwitchToVariationAction(title, project, file, virtualFile.equals(file)));
                }
                group.addSeparator();
            }
            if ((folderType = ResourceHelper.getFolderType(configuration.getFile())) == ResourceFolderType.LAYOUT) {
                boolean haveLandscape = false;
                boolean haveLarge = false;
                for (VirtualFile file : variations) {
                    ScreenSizeQualifier size;
                    FolderConfiguration config;
                    String name = file.getParent().getName();
                    if (!name.startsWith("layout") || (config = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
                    ScreenOrientationQualifier orientation = config.getScreenOrientationQualifier();
                    if (orientation != null && orientation.getValue() == ScreenOrientation.LANDSCAPE) {
                        haveLandscape = true;
                        if (haveLarge) break;
                    }
                    if ((size = config.getScreenSizeQualifier()) == null || size.getValue() != ScreenSize.XLARGE) continue;
                    haveLarge = true;
                    if (!haveLandscape) continue;
                    break;
                }
                if (!haveLandscape) {
                    group.add((AnAction)new CreateVariationAction(this.mySurface, "Create Landscape Variation", "layout-land"));
                }
                if (!haveLarge) {
                    group.add((AnAction)new CreateVariationAction(this.mySurface, "Create layout-xlarge Variation", "layout-xlarge"));
                }
                group.add((AnAction)new CreateVariationAction(this.mySurface, "Create Other...", null));
            } else {
                group.add((AnAction)new CreateVariationAction(this.mySurface, "Create Alternative...", null));
            }
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/ConfigurationMenuAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    private void addMultiConfigActions(DefaultActionGroup group) {
        Configuration configuration = this.mySurface.getConfiguration();
        if (configuration == null) {
            return;
        }
        VirtualFile file = configuration.getFile();
        if (file == null) {
            return;
        }
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        group.addSeparator();
        group.add((AnAction)new PreviewAction(this.mySurface, "Preview Representative Sample", 3, RenderPreviewMode.DEFAULT, true));
        ConfigurationMenuAction.addScreenSizeAction(this.mySurface, group);
        boolean haveMultipleLocales = configurationManager.getLocales().size() > 1;
        ConfigurationMenuAction.addLocalePreviewAction(this.mySurface, group, haveMultipleLocales);
        ConfigurationMenuAction.addRtlPreviewAction(this.mySurface, group);
        ConfigurationMenuAction.addApiLevelPreviewAction(this.mySurface, group);
        boolean DISABLE_RENDER_INCLUDED = true;
        boolean canPreviewIncluded = !DISABLE_RENDER_INCLUDED && ConfigurationMenuAction.hasCapability(this.mySurface, 4);
        group.add((AnAction)new PreviewAction(this.mySurface, "Preview Included", 3, RenderPreviewMode.INCLUDES, canPreviewIncluded));
        List<VirtualFile> variations = ResourceHelper.getResourceVariations(file, true);
        group.add((AnAction)new PreviewAction(this.mySurface, "Preview Layout Versions", 3, RenderPreviewMode.VARIATIONS, variations.size() > 1));
        group.add((AnAction)new PreviewAction(this.mySurface, "None", 3, RenderPreviewMode.NONE, true));
        group.addSeparator();
        group.add(new AnAction("Toggle Layout Mode"){

            public void actionPerformed(AnActionEvent e) {
            }
        });
    }

    static void addLocalePreviewAction(@NotNull EditorDesignSurface context, @NotNull DefaultActionGroup group, boolean enabled) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addLocalePreviewAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addLocalePreviewAction"));
        }
        group.add((AnAction)new PreviewAction(context, "Preview All Locales", 3, RenderPreviewMode.LOCALES, enabled));
    }

    static void addRtlPreviewAction(@NotNull EditorDesignSurface context, @NotNull DefaultActionGroup group) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addRtlPreviewAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addRtlPreviewAction"));
        }
        boolean enabled = ConfigurationMenuAction.hasCapability(context, 11);
        group.add((AnAction)new PreviewAction(context, "Preview Right-to-Left Layout", 3, RenderPreviewMode.RTL, enabled));
    }

    static void addApiLevelPreviewAction(@NotNull EditorDesignSurface context, @NotNull DefaultActionGroup group) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addApiLevelPreviewAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addApiLevelPreviewAction"));
        }
        boolean enabled = ConfigurationMenuAction.hasCapability(context, 13);
        group.add((AnAction)new PreviewAction(context, "Preview Android Versions", 3, RenderPreviewMode.API_LEVELS, enabled));
    }

    private static boolean hasCapability(EditorDesignSurface context, int capability) {
        IAndroidTarget target;
        Configuration configuration = context.getConfiguration();
        if (configuration == null) {
            return false;
        }
        boolean enabled = false;
        Module module = configuration.getModule();
        if (module != null && (target = configuration.getTarget()) != null) {
            LayoutLibrary library = RenderService.getLayoutLibrary(module, target);
            enabled = library != null && library.supports(capability);
        }
        return enabled;
    }

    static void addScreenSizeAction(@NotNull EditorDesignSurface context, @NotNull DefaultActionGroup group) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addScreenSizeAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addScreenSizeAction"));
        }
        boolean enabled = false;
        group.add((AnAction)new PreviewAction(context, "Preview All Screen Sizes", 3, RenderPreviewMode.SCREENS, enabled));
    }

    static void addRemovePreviewsAction(@NotNull EditorDesignSurface context, @NotNull DefaultActionGroup group) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addRemovePreviewsAction"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/configurations/ConfigurationMenuAction", "addRemovePreviewsAction"));
        }
        boolean enabled = false;
        group.add((AnAction)new PreviewAction(context, "Remove Previews", 3, RenderPreviewMode.NONE, enabled));
    }

    private static class CreateVariationAction
    extends AnAction {
        @NotNull
        private EditorDesignSurface mySurface;
        @Nullable
        private String myNewFolder;

        public CreateVariationAction(@NotNull EditorDesignSurface surface, @NotNull String title, @Nullable String newFolder) {
            if (surface == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/configurations/ConfigurationMenuAction$CreateVariationAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/configurations/ConfigurationMenuAction$CreateVariationAction", "<init>"));
            }
            super(title, null, null);
            this.mySurface = surface;
            this.myNewFolder = newFolder;
        }

        public void actionPerformed(AnActionEvent e) {
            OverrideResourceAction.forkResourceFile(this.mySurface, this.myNewFolder, true);
        }
    }

    private static class SwitchToVariationAction
    extends AnAction {
        private final Project myProject;
        private final VirtualFile myFile;

        public SwitchToVariationAction(String title, @NotNull Project project, VirtualFile file, boolean select) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/configurations/ConfigurationMenuAction$SwitchToVariationAction", "<init>"));
            }
            super(title, null, null);
            this.myFile = file;
            this.myProject = project;
            if (select) {
                Presentation templatePresentation = this.getTemplatePresentation();
                templatePresentation.setIcon(AllIcons.Actions.Checked);
                templatePresentation.setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, this.myFile, -1);
            FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
        }
    }

    private static class PreviewAction
    extends AnAction {
        private final int myAction;
        private final RenderPreviewMode myMode;
        private final EditorDesignSurface mySurface;

        public PreviewAction(@NotNull EditorDesignSurface surface, @NotNull String title, int action, @Nullable RenderPreviewMode mode, boolean enabled) {
            if (surface == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/configurations/ConfigurationMenuAction$PreviewAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/configurations/ConfigurationMenuAction$PreviewAction", "<init>"));
            }
            super(title, null, null);
            this.mySurface = surface;
            this.myAction = action;
            this.myMode = mode;
            if (mode != null && mode == RenderPreviewMode.getCurrent()) {
                Presentation templatePresentation = this.getTemplatePresentation();
                templatePresentation.setIcon(AllIcons.Actions.Checked);
                templatePresentation.setEnabled(false);
            }
            if (!enabled) {
                this.getTemplatePresentation().setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }
}

