/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations.nodes;

import com.android.ddmlib.AllocationInfo;
import com.android.tools.idea.editors.allocations.nodes.AbstractTreeNode;
import com.android.tools.idea.editors.allocations.nodes.AllocNode;
import com.android.tools.idea.editors.allocations.nodes.PackageNode;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ClassNode
extends PackageNode {
    @NotNull
    private Map<String, AllocNode> mySimilarObjectsMap;

    public ClassNode(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/allocations/nodes/ClassNode", "<init>"));
        }
        super(name);
        this.mySimilarObjectsMap = new HashMap<String, AllocNode>();
    }

    @Override
    protected void addChild(@NotNull AbstractTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/allocations/nodes/ClassNode", "addChild"));
        }
        assert (node instanceof AllocNode);
        AllocationInfo allocInfo = ((AllocNode)node).getAllocation();
        String key = String.format("%s,%s", allocInfo.getAllocatedClass(), allocInfo.getSize());
        if (this.mySimilarObjectsMap.containsKey(key)) {
            this.mySimilarObjectsMap.get(key).incrementCount();
        } else {
            super.addChild(node);
            this.mySimilarObjectsMap.put(key, (AllocNode)node);
        }
    }
}

