/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.ui;

import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ui.VariantsComboBox;
import com.android.tools.swing.ui.SwatchComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceComponent
extends JPanel {
    public static final String NAME_LABEL = "Name Label";
    private final SwatchComponent mySwatchComponent;
    private final JLabel myNameLabel;
    protected final JLabel myWarningLabel;
    private final VariantsComboBox myVariantCombo;

    public ResourceComponent(@NotNull Project project, boolean isEditor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "<init>"));
        }
        super(new BorderLayout(0, ThemeEditorConstants.ATTRIBUTE_ROW_GAP));
        this.myNameLabel = new JLabel();
        this.myWarningLabel = new JLabel();
        this.myVariantCombo = new VariantsComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0, ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0));
        this.myWarningLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myWarningLabel.setVisible(false);
        this.myNameLabel.setName(NAME_LABEL);
        this.myNameLabel.setForeground((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR);
        Box topRowPanel = new Box(2);
        topRowPanel.add(this.myNameLabel);
        topRowPanel.add(this.myWarningLabel);
        this.myVariantCombo.setVisible(false);
        topRowPanel.add(Box.createHorizontalGlue());
        topRowPanel.add(this.myVariantCombo);
        this.add((Component)topRowPanel, "Center");
        this.mySwatchComponent = new SwatchComponent(project, isEditor);
        this.add((Component)this.mySwatchComponent, "South");
        ThemeEditorUtils.setInheritsPopupMenuRecursive(this);
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int firstRowHeight = Math.max(this.getFontMetrics(this.getFont()).getHeight(), this.myVariantCombo.getPreferredSize().height);
            int secondRowHeight = this.mySwatchComponent.getPreferredSize().height;
            return new Dimension(0, ThemeEditorConstants.ATTRIBUTE_MARGIN + ThemeEditorConstants.ATTRIBUTE_ROW_GAP + firstRowHeight + secondRowHeight);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
    }

    public void setSwatchIcon(@NotNull SwatchComponent.SwatchIcon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "setSwatchIcon"));
        }
        this.mySwatchComponent.setSwatchIcon(icon);
    }

    public void setNameText(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "setNameText"));
        }
        this.myNameLabel.setText(name);
    }

    public void setWarning(@Nullable String warning) {
        if (!StringUtil.isEmpty((String)warning)) {
            this.myWarningLabel.setToolTipText(warning);
            this.myWarningLabel.setVisible(true);
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    public void setVariantsModel(@NotNull ComboBoxModel comboBoxModel) {
        if (comboBoxModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBoxModel", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "setVariantsModel"));
        }
        this.myVariantCombo.setModel(comboBoxModel);
        this.myVariantCombo.setVisible(comboBoxModel.getSize() > 0);
    }

    public void addVariantItemListener(@NotNull ItemListener itemListener) {
        if (itemListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemListener", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "addVariantItemListener"));
        }
        this.myVariantCombo.addItemListener(itemListener);
    }

    public void addVariantPopupClosingListener(@NotNull VariantsComboBox.PopupClosingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "addVariantPopupClosingListener"));
        }
        this.myVariantCombo.addPopupClosingListener(listener);
    }

    public void setValueText(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "setValueText"));
        }
        this.mySwatchComponent.setText(value);
    }

    @NotNull
    public String getValueText() {
        String string = this.mySwatchComponent.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "getValueText"));
        }
        return string;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.mySwatchComponent != null) {
            this.mySwatchComponent.setFont(font);
        }
        if (this.myNameLabel != null) {
            this.myNameLabel.setFont(font);
        }
    }

    public void addSwatchListener(@NotNull ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "addSwatchListener"));
        }
        this.mySwatchComponent.addSwatchListener(listener);
    }

    public void addTextListener(@NotNull ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "addTextListener"));
        }
        this.mySwatchComponent.addTextListener(listener);
    }

    public void addTextDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "addTextDocumentListener"));
        }
        this.mySwatchComponent.addTextDocumentListener(listener);
    }

    public void addTextFocusListener(@NotNull FocusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "addTextFocusListener"));
        }
        this.mySwatchComponent.addTextFocusListener(listener);
    }

    public void setCompletionStrings(@NotNull List<String> completions) {
        if (completions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completions", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "setCompletionStrings"));
        }
        this.mySwatchComponent.setCompletionStrings(completions);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myWarningLabel.isVisible()) {
            this.validate();
            if (SwingUtilities.getLocalBounds(this.myWarningLabel).contains(SwingUtilities.convertMouseEvent(this, event, this.myWarningLabel).getPoint())) {
                return this.myWarningLabel.getToolTipText();
            }
        }
        return super.getToolTipText(event);
    }

    public Dimension getSwatchIconSize() {
        return new Dimension(this.mySwatchComponent.getHeight(), this.mySwatchComponent.getHeight());
    }

    @Nullable
    public ValidationInfo doValidate(int minApi, @NotNull AndroidTargetData androidTargetData) {
        if (androidTargetData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidTargetData", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "doValidate"));
        }
        return this.mySwatchComponent.doValidate(minApi, androidTargetData);
    }
}

