/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.idea.fd.BuildMode;
import org.jetbrains.annotations.NotNull;

public enum BuildCause {
    USER_REQUESTED_CLEAN_BUILD(BuildMode.CLEAN),
    NO_DEVICE(BuildMode.FULL),
    APP_NOT_INSTALLED(BuildMode.FULL),
    MISMATCHING_TIMESTAMPS(BuildMode.FULL),
    API_TOO_LOW_FOR_INSTANT_RUN(BuildMode.FULL),
    FIRST_INSTALLATION_TO_DEVICE(BuildMode.FULL),
    MANIFEST_RESOURCE_CHANGED(BuildMode.FULL),
    FREEZE_SWAP_REQUIRES_API21(BuildMode.FULL),
    USER_REQUESTED_COLDSWAP(BuildMode.COLD),
    USER_CHOSE_TO_COLDSWAP(BuildMode.COLD),
    APP_NOT_RUNNING(BuildMode.COLD),
    APP_USES_MULTIPLE_PROCESSES(BuildMode.COLD),
    ANDROID_TV_UNSUPPORTED(BuildMode.COLD),
    INCREMENTAL_BUILD(BuildMode.HOT);

    @NotNull
    private final BuildMode myBuildMode;

    @NotNull
    public BuildMode getBuildMode() {
        BuildMode buildMode = this.myBuildMode;
        if (buildMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/BuildCause", "getBuildMode"));
        }
        return buildMode;
    }

    private BuildCause(BuildMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/fd/BuildCause", "<init>"));
        }
        this.myBuildMode = mode;
    }

    public String toString() {
        return "BuildCause: " + super.name() + ", BuildMode: " + this.myBuildMode.toString();
    }
}

