/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.actions.LinkExternalCppProjectDialog;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkExternalCppProjectAction
extends AndroidStudioGradleAction {
    public LinkExternalCppProjectAction() {
        super("Link C++ Project with Gradle", "Link an external C/C++ project (cmake or ndk-build) with Gradle", null);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/LinkExternalCppProjectAction", "doUpdate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/LinkExternalCppProjectAction", "doUpdate"));
        }
        DataContext dataContext = e.getDataContext();
        boolean enable = LinkExternalCppProjectAction.isValidAndroidGradleModuleSelected(dataContext);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(enable);
        presentation.setVisible(enable);
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/actions/LinkExternalCppProjectAction", "doPerform"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/actions/LinkExternalCppProjectAction", "doPerform"));
        }
        DataContext dataContext = e.getDataContext();
        Module module = LinkExternalCppProjectAction.getSelectedModule(dataContext);
        assert (module != null);
        new LinkExternalCppProjectDialog(module).show();
    }

    private static boolean isValidAndroidGradleModuleSelected(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/actions/LinkExternalCppProjectAction", "isValidAndroidGradleModuleSelected"));
        }
        Module module = LinkExternalCppProjectAction.getSelectedModule(dataContext);
        if (module == null) {
            return false;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel == null || !androidModel.getFeatures().isExternalBuildSupported()) {
            return false;
        }
        AndroidPluginGeneration pluginGeneration = AndroidPluginGeneration.find(module);
        if (pluginGeneration == AndroidPluginGeneration.COMPONENT) {
            return false;
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
        if (ndkModuleModel != null) {
            return false;
        }
        return GradleBuildModel.get(module) != null;
    }

    @Nullable
    private static Module getSelectedModule(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/actions/LinkExternalCppProjectAction", "getSelectedModule"));
        }
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modules != null && modules.length == 1) {
            return modules[0];
        }
        return (Module)LangDataKeys.MODULE.getData(dataContext);
    }
}

