/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesModel
extends GradleDslBlockModel {
    public DependenciesModel(@NotNull DependenciesDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "<init>"));
        }
        super(dslElement);
    }

    @NotNull
    public List<DependencyModel> all() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModel.create(element));
                if (!(element instanceof GradleDslMethodCall)) continue;
                GradleDslMethodCall methodCall = (GradleDslMethodCall)element;
                dependencies.addAll(ModuleDependencyModel.create(configurationName, methodCall));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "all"));
        }
        return arrayList;
    }

    @NotNull
    public List<ArtifactDependencyModel> artifacts(@NotNull String configurationName) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "artifacts"));
        }
        ArrayList dependencies = Lists.newArrayList();
        this.addArtifacts(configurationName, dependencies);
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "artifacts"));
        }
        return arrayList;
    }

    @NotNull
    public List<ArtifactDependencyModel> artifacts() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            this.addArtifacts(configurationName, dependencies);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "artifacts"));
        }
        return arrayList;
    }

    private void addArtifacts(@NotNull String configurationName, @NotNull List<ArtifactDependencyModel> dependencies) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifacts"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifacts"));
        }
        GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
        if (list != null) {
            for (GradleDslElement element : list.getElements(GradleDslElement.class)) {
                dependencies.addAll(ArtifactDependencyModel.create(element));
            }
        }
    }

    public boolean containsArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "containsArtifact"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "containsArtifact"));
        }
        for (ArtifactDependencyModel artifactDependencyModel : this.artifacts(configurationName)) {
            if (!ArtifactDependencySpec.create(artifactDependencyModel).equals(dependency)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull String compactNotation) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        if (compactNotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compactNotation", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        ArtifactDependencySpec dependency = ArtifactDependencySpec.create(compactNotation);
        if (dependency == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            throw new IllegalArgumentException(msg);
        }
        this.addArtifact(configurationName, dependency);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        DependenciesModel dependenciesModel = this.addArtifact(configurationName, dependency, Collections.emptyList());
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ArtifactDependencyModel.createAndAddToList(list, configurationName, dependency, excludes);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addArtifact"));
        }
        return dependenciesModel;
    }

    @NotNull
    public List<ModuleDependencyModel> modules() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(ModuleDependencyModel.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "modules"));
        }
        return arrayList;
    }

    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        DependenciesModel dependenciesModel = this.addModule(configurationName, path, null);
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addModule(@NotNull String configurationName, @NotNull String path, @Nullable String config) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        ModuleDependencyModel.createAndAddToList(list, configurationName, path, config);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addModule"));
        }
        return dependenciesModel;
    }

    @NotNull
    public List<FileTreeDependencyModel> fileTrees() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(FileTreeDependencyModel.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "fileTrees"));
        }
        return arrayList;
    }

    @NotNull
    public DependenciesModel addFileTree(@NotNull String configurationName, @NotNull String dir) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addFileTree"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addFileTree"));
        }
        DependenciesModel dependenciesModel = this.addFileTree(configurationName, dir, null, null);
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addFileTree"));
        }
        return dependenciesModel;
    }

    @NotNull
    public DependenciesModel addFileTree(@NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addFileTree"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addFileTree"));
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        FileTreeDependencyModel.createAndAddToList(list, configurationName, dir, includes, excludes);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addFileTree"));
        }
        return dependenciesModel;
    }

    @NotNull
    public List<FileDependencyModel> files() {
        ArrayList dependencies = Lists.newArrayList();
        for (String configurationName : this.myDslElement.getProperties()) {
            GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
            if (list == null) continue;
            for (GradleDslMethodCall element : list.getElements(GradleDslMethodCall.class)) {
                dependencies.addAll(FileDependencyModel.create(configurationName, element));
            }
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "files"));
        }
        return arrayList;
    }

    @NotNull
    public DependenciesModel addFile(@NotNull String configurationName, @NotNull String file) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addFile"));
        }
        GradleDslElementList list = this.getOrCreateGradleDslElementList(configurationName);
        FileDependencyModel.createAndAddToList(list, configurationName, file);
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "addFile"));
        }
        return dependenciesModel;
    }

    @NotNull
    private GradleDslElementList getOrCreateGradleDslElementList(@NotNull String configurationName) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "getOrCreateGradleDslElementList"));
        }
        GradleDslElementList list = this.myDslElement.getPropertyElement(configurationName, GradleDslElementList.class);
        if (list == null) {
            list = new GradleDslElementList(this.myDslElement, configurationName);
            this.myDslElement.setNewElement(configurationName, list);
        }
        GradleDslElementList gradleDslElementList = list;
        if (gradleDslElementList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "getOrCreateGradleDslElementList"));
        }
        return gradleDslElementList;
    }

    @NotNull
    public DependenciesModel remove(@NotNull DependencyModel dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "remove"));
        }
        GradleDslElementList gradleDslElementList = this.myDslElement.getPropertyElement(dependency.configurationName(), GradleDslElementList.class);
        if (gradleDslElementList != null) {
            GradleDslElement dependencyElement = dependency.getDslElement();
            GradleDslElement parent = dependencyElement.getParent();
            if (parent instanceof GradleDslMethodCall) {
                GradleDslMethodCall methodCall = (GradleDslMethodCall)parent;
                List<GradleDslElement> arguments = methodCall.getArguments();
                if (arguments.size() == 1 && arguments.get(0).equals(dependencyElement)) {
                    gradleDslElementList.removeElement(methodCall);
                } else {
                    methodCall.remove(dependencyElement);
                }
            } else {
                gradleDslElementList.removeElement(dependencyElement);
            }
        }
        DependenciesModel dependenciesModel = this;
        if (dependenciesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/dependencies/DependenciesModel", "remove"));
        }
        return dependenciesModel;
    }
}

