/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.project.BuildSystemService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class GradleBuildSystemService
extends BuildSystemService {
    @Override
    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleBuildSystemService", "isApplicable"));
        }
        return GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }

    @Override
    public void buildProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleBuildSystemService", "buildProject"));
        }
        GradleProjectBuilder.getInstance(project).compileJava();
    }

    @Override
    public void syncProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleBuildSystemService", "syncProject"));
        }
        BuildVariantView.getInstance(project).projectImportStarted();
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
    }

    @Override
    public void addDependency(@NotNull Module module, @NotNull String artifact) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/GradleBuildSystemService", "addDependency"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/project/GradleBuildSystemService", "addDependency"));
        }
        GradleDependencyManager manager = GradleDependencyManager.getInstance(module.getProject());
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)(artifact + ":+"));
        manager.ensureLibraryIsIncluded(module, Collections.singletonList(coordinate), null);
    }
}

