/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProjectInfo {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myProjectInfo;

    @NotNull
    public static GradleProjectInfo getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectInfo", "getInstance"));
        }
        GradleProjectInfo gradleProjectInfo = (GradleProjectInfo)ServiceManager.getService((Project)project, GradleProjectInfo.class);
        if (gradleProjectInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectInfo", "getInstance"));
        }
        return gradleProjectInfo;
    }

    public GradleProjectInfo(@NotNull Project project, @NotNull AndroidProjectInfo projectInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectInfo", "<init>"));
        }
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/project/GradleProjectInfo", "<init>"));
        }
        this.myProject = project;
        this.myProjectInfo = projectInfo;
    }

    public boolean hasTopLevelGradleBuildFile() {
        File projectFolderPath = Projects.getBaseDirPath(this.myProject);
        File buildFilePath = new File(projectFolderPath, "build.gradle");
        return buildFilePath.isFile();
    }

    public boolean isBuildWithGradle() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            if (!Projects.isBuildWithGradle(module)) continue;
            return true;
        }
        return GradleSyncState.getInstance(this.myProject).getSummary().getSyncTimestamp() != -1L;
    }

    @NotNull
    public List<Module> getAndroidModules() {
        ImmutableList.Builder modules = ImmutableList.builder();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            if (!Projects.isBuildWithGradle(module)) continue;
            modules.add((Object)module);
        }
        ImmutableList immutableList = modules.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectInfo", "getAndroidModules"));
        }
        return immutableList;
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/GradleProjectInfo", "findAndroidModelInModule"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            VirtualFile rootFolder;
            if (this.myProjectInfo.requiresAndroidModel() && (rootFolder = this.myProject.getBaseDir()) != null) {
                for (VirtualFile parent = file.getParent(); parent != null && parent.equals(rootFolder) && (module = ModuleUtilCore.findModuleForFile((VirtualFile)parent, (Project)this.myProject)) == null; parent = parent.getParent()) {
                }
            }
            if (module == null) {
                return null;
            }
        }
        if (module.isDisposed()) {
            this.getLog().warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        return AndroidModuleModel.get(module);
    }

    @NotNull
    private Logger getLog() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectInfo", "getLog"));
        }
        return logger;
    }
}

