/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProjectSyncData
implements Serializable {
    @NotNull
    @NonNls
    private static final String STATE_FILE_NAME = "gradle_project_sync_data.bin";
    private static final boolean ENABLED = !Boolean.getBoolean("studio.disable.synccache");
    private static final Logger LOG = Logger.getInstance(GradleProjectSyncData.class);
    private Map<String, byte[]> myFileChecksums = Maps.newHashMap();
    private String myGradlePluginVersion = "2.3.0";
    private long myLastGradleSyncTimestamp = -1L;
    private transient File myRootDirPath;

    private GradleProjectSyncData() {
    }

    @Nullable
    public static GradleProjectSyncData getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "getInstance"));
        }
        if (!ENABLED || GradleProjectSyncData.needsAndroidSdkSync(project)) {
            return null;
        }
        try {
            return GradleProjectSyncData.doLoadFromDisk(project);
        }
        catch (IOException e) {
            LOG.info(String.format("Error accessing state cache for project '%1$s', sync will be needed.", project.getName()));
        }
        catch (ClassNotFoundException e) {
            LOG.info(String.format("Cannot recover state cache for project '%1$s', sync will be needed.", project.getName()));
        }
        return null;
    }

    private static boolean needsAndroidSdkSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "needsAndroidSdkSync"));
        }
        if (IdeInfo.getInstance().isAndroidStudio()) {
            File ideSdkPath = IdeSdks.getInstance().getAndroidSdkPath();
            if (ideSdkPath != null) {
                try {
                    LocalProperties localProperties = new LocalProperties(project);
                    File projectSdkPath = localProperties.getAndroidSdkPath();
                    return projectSdkPath == null || !FileUtil.filesEqual((File)ideSdkPath, (File)projectSdkPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static GradleProjectSyncData doLoadFromDisk(@NotNull Project project) throws IOException, ClassNotFoundException {
        GradleProjectSyncData gradleProjectSyncData;
        File dataFile;
        File rootDirPath;
        FileInputStream fin;
        block7: {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "doLoadFromDisk"));
            }
            fin = null;
            rootDirPath = Projects.getBaseDirPath(project);
            dataFile = GradleProjectSyncData.getProjectStateFile(project);
            if (dataFile.exists()) break block7;
            GradleProjectSyncData gradleProjectSyncData2 = null;
            {
                catch (Throwable throwable) {
                    Closeables.close(fin, (boolean)false);
                    throw throwable;
                }
            }
            Closeables.close(fin, (boolean)false);
            return gradleProjectSyncData2;
        }
        fin = new FileInputStream(dataFile);
        ObjectInputStream ois = new ObjectInputStream(fin);
        try {
            GradleProjectSyncData data = (GradleProjectSyncData)ois.readObject();
            data.myRootDirPath = rootDirPath;
            gradleProjectSyncData = data;
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable)ois, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)ois, (boolean)false);
        Closeables.close((Closeable)fin, (boolean)false);
        return gradleProjectSyncData;
    }

    public static void save(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "save"));
        }
        if (!ENABLED) {
            return;
        }
        boolean cacheSaved = false;
        try {
            GradleProjectSyncData data = GradleProjectSyncData.createFrom(project);
            if (data != null) {
                File file = GradleProjectSyncData.getProjectStateFile(project);
                FileUtil.ensureExists((File)file.getParentFile());
                data.saveTo(file);
                cacheSaved = true;
            }
        }
        catch (IOException e) {
            LOG.info(String.format("Error while saving persistent state from project '%1$s'", project.getName()), (Throwable)e);
        }
        if (!cacheSaved) {
            LOG.info("Failed to generate new cache. Deleting the old one.");
            GradleProjectSyncData.removeFrom(project);
        }
    }

    @Nullable
    static GradleProjectSyncData createFrom(@NotNull Project project) throws IOException {
        Module[] modules;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "createFrom"));
        }
        GradleProjectSyncData data = new GradleProjectSyncData();
        File rootDirPath = Projects.getBaseDirPath(project);
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            NdkModuleModel ndkModuleModel;
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet != null) {
                GradleModuleModel gradleModuleModel = gradleFacet.getGradleModuleModel();
                if (gradleModuleModel != null) {
                    data.addFileChecksum(rootDirPath, gradleModuleModel.getBuildFile());
                } else {
                    LOG.warn(String.format("Trying to create project data from a not initialized project '%1$s'. Abort.", project.getName()));
                    return null;
                }
            }
            if (Projects.isGradleProjectModule(module)) {
                data.addFileChecksum(rootDirPath, GradleUtil.getGradleBuildFile(module));
                data.addFileChecksum(rootDirPath, GradleUtil.getGradleSettingsFile(rootDirPath));
                data.addFileChecksum(rootDirPath, new File(rootDirPath, "gradle.properties"));
                data.addFileChecksum(rootDirPath, new File(rootDirPath, "local.properties"));
                data.addFileChecksum(rootDirPath, GradleUtil.getGradleUserSettingsFile());
            }
            if ((ndkModuleModel = NdkModuleModel.get(module)) == null) continue;
            for (File externalBuildFile : ndkModuleModel.getAndroidProject().getBuildFiles()) {
                data.addFileChecksum(rootDirPath, externalBuildFile);
            }
        }
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        data.myLastGradleSyncTimestamp = syncState.getSummary().getSyncTimestamp();
        return data;
    }

    @NotNull
    private static File getProjectStateFile(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "getProjectStateFile"));
        }
        File file = new File(PathManager.getSystemPath(), FileUtil.join((String[])new String[]{"external_build_system", "Projects", project.getLocationHash(), STATE_FILE_NAME}));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "getProjectStateFile"));
        }
        return file;
    }

    private void addFileChecksum(File rootDirPath, @Nullable VirtualFile vf) throws IOException {
        this.addFileChecksum(rootDirPath, vf != null ? VfsUtilCore.virtualToIoFile((VirtualFile)vf) : null);
    }

    private void addFileChecksum(File rootDirPath, @Nullable File file) throws IOException {
        if (file == null) {
            return;
        }
        String key = FileUtil.isAncestor((File)rootDirPath, (File)file, (boolean)true) ? FileUtil.getRelativePath((File)rootDirPath, (File)file) : file.getAbsolutePath();
        this.myFileChecksums.put(key, GradleProjectSyncData.createChecksum(file));
    }

    @NotNull
    private static byte[] createChecksum(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "createChecksum"));
        }
        VirtualFile vf = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        byte[] data = new byte[]{};
        if (vf != null) {
            vf.refresh(false, false);
            if (vf.exists()) {
                data = vf.contentsToByteArray();
            }
        } else if (file.exists()) {
            data = Files.toByteArray((File)file);
        }
        byte[] byArray = Hashing.md5().hashBytes(data).asBytes();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "createChecksum"));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTo(File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            try {
                oos.writeObject(this);
            }
            finally {
                Closeables.close((Closeable)oos, (boolean)false);
            }
        }
        finally {
            Closeables.close((Closeable)fos, (boolean)false);
        }
    }

    public static void removeFrom(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/GradleProjectSyncData", "removeFrom"));
        }
        if (!ENABLED) {
            return;
        }
        try {
            File stateFile = GradleProjectSyncData.getProjectStateFile(project);
            if (stateFile.isFile()) {
                FileUtil.delete((File)stateFile);
            }
        }
        catch (IOException e) {
            LOG.warn(String.format("Failed to remove state for project %1$s'", project.getName()));
        }
    }

    public boolean canUseCachedProjectData() {
        if (!this.myGradlePluginVersion.equals("2.3.0")) {
            return false;
        }
        for (Map.Entry<String, byte[]> entry : this.myFileChecksums.entrySet()) {
            File file = new File(entry.getKey());
            if (!file.isAbsolute()) {
                file = new File(this.myRootDirPath, file.getPath());
            }
            try {
                if (Arrays.equals(entry.getValue(), GradleProjectSyncData.createChecksum(file))) continue;
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public long getLastGradleSyncTimestamp() {
        return this.myLastGradleSyncTimestamp;
    }

    Map<String, byte[]> getFileChecksums() {
        return this.myFileChecksums;
    }
}

