/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class GradleBuildInvoker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleTasksExecutor.Factory myTaskExecutorFactory;
    @NotNull
    private final Set<AfterGradleInvocationTask> myAfterTasks;
    @NotNull
    private final List<String> myOneTimeGradleOptions;
    @NotNull
    private final List<String> myLastBuildTasks;
    @NotNull
    private final BuildStopper myBuildStopper;

    public static GradleBuildInvoker getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getInstance"));
        }
        return (GradleBuildInvoker)ServiceManager.getService((Project)project, GradleBuildInvoker.class);
    }

    public GradleBuildInvoker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "<init>"));
        }
        this(project, new GradleTasksExecutor.Factory());
    }

    @VisibleForTesting
    GradleBuildInvoker(@NotNull Project project, @NotNull GradleTasksExecutor.Factory tasksExecutorFactory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "<init>"));
        }
        if (tasksExecutorFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasksExecutorFactory", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "<init>"));
        }
        this.myAfterTasks = new LinkedHashSet<AfterGradleInvocationTask>();
        this.myOneTimeGradleOptions = new ArrayList<String>();
        this.myLastBuildTasks = new ArrayList<String>();
        this.myBuildStopper = new BuildStopper();
        this.myProject = project;
        this.myTaskExecutorFactory = tasksExecutorFactory;
    }

    public void cleanProject() {
        this.setProjectBuildMode(BuildMode.CLEAN);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(moduleManager.getModules(), BuildMode.SOURCE_GEN, TestCompileType.NONE);
        tasks.add(0, "clean");
        this.executeTasks(tasks, Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
    }

    public void assembleTranslate() {
        this.setProjectBuildMode(BuildMode.ASSEMBLE_TRANSLATE);
        this.executeTasks(Collections.singletonList("assembleTranslate"));
    }

    public void generateSources(boolean cleanProject) {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        if (cleanProject) {
            tasks.add(0, "clean");
        }
        this.executeTasks(tasks, Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
    }

    @NotNull
    private static String createGenerateSourcesOnlyProperty() {
        String string = AndroidGradleSettings.createProjectProperty((String)"android.injected.generateSourcesOnly", (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "createGenerateSourcesOnlyProperty"));
        }
        return string;
    }

    public void compileJava(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "compileJava"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "compileJava"));
        }
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "assemble"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "assemble"));
        }
        this.assemble(modules, testCompileType, Collections.emptyList());
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @NotNull List<String> arguments) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "assemble"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "assemble"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "assemble"));
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks, arguments);
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleBuildInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        this.executeTasks(tasks);
    }

    public void rebuildWithTempOptions(@NotNull List<String> options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "rebuildWithTempOptions"));
        }
        this.myOneTimeGradleOptions.addAll(options);
        try {
            if (this.myLastBuildTasks.isEmpty()) {
                this.rebuild();
            } else {
                ArrayList<String> tasksFromLastBuild = new ArrayList<String>();
                tasksFromLastBuild.addAll(this.myLastBuildTasks);
                this.executeTasks(tasksFromLastBuild);
            }
        }
        finally {
            this.myOneTimeGradleOptions.clear();
        }
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "setProjectBuildMode"));
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    @NotNull
    public static List<String> findCleanTasksForModules(@NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findCleanTasksForModules"));
        }
        ArrayList<String> tasks = new ArrayList<String>();
        for (Module module : modules) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            String gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, "clean");
        }
        ArrayList<String> arrayList = tasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findCleanTasksForModules"));
        }
        return arrayList;
    }

    @NotNull
    public static List<String> findTasksToExecute(@NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        Project project;
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findTasksToExecute"));
        }
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findTasksToExecute"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findTasksToExecute"));
        }
        ArrayList<String> tasks = new ArrayList<String>();
        if (BuildMode.ASSEMBLE == buildMode && GradleSyncState.getInstance(project = modules[0].getProject()).lastSyncFailed()) {
            List<String> list = Collections.singletonList("assemble");
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findTasksToExecute"));
            }
            return list;
        }
        for (Project module : modules) {
            if ("buildSrc".equals(module.getName())) continue;
            GradleBuildInvoker.findAndAddGradleBuildTasks((Module)module, buildMode, tasks, testCompileType);
        }
        if (buildMode == BuildMode.REBUILD && !tasks.isEmpty()) {
            tasks.add(0, "clean");
        }
        if (tasks.isEmpty()) {
            String format = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            GradleBuildInvoker.getLogger().info(String.format(format, modules[0].getProject().getName(), buildMode.name()));
        }
        ArrayList<String> arrayList = tasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findTasksToExecute"));
        }
        return arrayList;
    }

    public void executeTasks(@NotNull List<String> gradleTasks) {
        if (gradleTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "executeTasks"));
        }
        this.executeTasks(gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull List<String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "executeTasks"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "executeTasks"));
        }
        if (buildMode != null) {
            this.setProjectBuildMode(buildMode);
        }
        this.executeTasks(tasks, commandLineArguments);
    }

    public void executeTasks(@NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments) {
        if (gradleTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "executeTasks"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "executeTasks"));
        }
        ArrayList<String> jvmArguments = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            File androidHomePath;
            LocalProperties localProperties;
            try {
                localProperties = new LocalProperties(this.myProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                jvmArguments.add(AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHomePath.getPath()));
            }
        }
        Request request = new Request(this.myProject, gradleTasks);
        request.setJvmArguments(jvmArguments).setCommandLineArguments(commandLineArguments);
        this.executeTasks(request);
    }

    public void executeTasks(@NotNull Request request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "executeTasks"));
        }
        this.myLastBuildTasks.clear();
        List<String> gradleTasks = request.getGradleTasks();
        this.myLastBuildTasks.addAll(gradleTasks);
        GradleBuildInvoker.getLogger().info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        GradleTasksExecutor executor = this.myTaskExecutorFactory.create(request, this.myBuildStopper);
        GradleBuildInvoker.saveAllFilesSafely();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            executor.queue();
        } else if (request.isWaitForCompletion()) {
            executor.queueAndWaitForCompletion();
        } else {
            UIUtil.invokeAndWaitIfNeeded(() -> ((GradleTasksExecutor)executor).queue());
        }
    }

    public static void saveAllFilesSafely() {
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments()));
    }

    private static void findAndAddGradleBuildTasks(@NotNull Module module, @NotNull BuildMode buildMode, @NotNull List<String> tasks, @NotNull TestCompileType testCompileType) {
        block18: {
            String gradlePath;
            block17: {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findAndAddGradleBuildTasks"));
                }
                if (buildMode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findAndAddGradleBuildTasks"));
                }
                if (tasks == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findAndAddGradleBuildTasks"));
                }
                if (testCompileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "findAndAddGradleBuildTasks"));
                }
                GradleFacet gradleFacet = GradleFacet.getInstance(module);
                if (gradleFacet == null) {
                    return;
                }
                gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                if (StringUtil.isEmpty((String)gradlePath)) {
                    String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module.getName());
                    GradleBuildInvoker.getLogger().info(msg);
                    return;
                }
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) break block17;
                JpsAndroidModuleProperties properties = androidFacet.getProperties();
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                switch (buildMode) {
                    case CLEAN: 
                    case SOURCE_GEN: {
                        GradleBuildInvoker.addAfterSyncTasks(tasks, gradlePath, properties);
                        GradleBuildInvoker.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                        break;
                    }
                    case ASSEMBLE: {
                        tasks.add(GradleBuildInvoker.createBuildTask(gradlePath, properties.ASSEMBLE_TASK_NAME));
                        if (testCompileType != TestCompileType.NONE) {
                            for (BaseArtifact artifact : GradleBuildInvoker.getArtifactsForTestCompileType(testCompileType, androidModel)) {
                                GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, artifact.getAssembleTaskName());
                            }
                        }
                        break block18;
                    }
                    default: {
                        GradleBuildInvoker.addAfterSyncTasks(tasks, gradlePath, properties);
                        GradleBuildInvoker.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                        if (testCompileType != TestCompileType.UNIT_TESTS) {
                            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, properties.COMPILE_JAVA_TASK_NAME);
                        }
                        for (BaseArtifact artifact : GradleBuildInvoker.getArtifactsForTestCompileType(testCompileType, androidModel)) {
                            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, artifact.getCompileTaskName());
                        }
                        break block18;
                    }
                }
                break block18;
            }
            JavaFacet javaFacet = JavaFacet.getInstance(module);
            if (javaFacet != null && ((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
                String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
                if (gradleTaskName != null) {
                    tasks.add(GradleBuildInvoker.createBuildTask(gradlePath, gradleTaskName));
                }
                if (testCompileType == TestCompileType.UNIT_TESTS) {
                    tasks.add(GradleBuildInvoker.createBuildTask(gradlePath, "testClasses"));
                }
            }
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(GradleBuildInvoker.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getLogger"));
        }
        return logger;
    }

    private static void addAfterSyncTasksForTestArtifacts(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull TestCompileType testCompileType, @Nullable AndroidModuleModel androidModel) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "addAfterSyncTasksForTestArtifacts"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "addAfterSyncTasksForTestArtifacts"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "addAfterSyncTasksForTestArtifacts"));
        }
        Collection<BaseArtifact> testArtifacts = GradleBuildInvoker.getArtifactsForTestCompileType(testCompileType, androidModel);
        for (BaseArtifact artifact : testArtifacts) {
            for (String taskName : AndroidModuleModel.getIdeSetupTasks(artifact)) {
                GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, taskName);
            }
        }
    }

    @NotNull
    private static Collection<BaseArtifact> getArtifactsForTestCompileType(@NotNull TestCompileType testCompileType, @Nullable AndroidModuleModel androidModel) {
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getArtifactsForTestCompileType"));
        }
        if (androidModel == null) {
            List<BaseArtifact> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getArtifactsForTestCompileType"));
            }
            return list;
        }
        AndroidArtifact testArtifact = null;
        switch (testCompileType) {
            case NONE: {
                Collection<BaseArtifact> collection = androidModel.getTestArtifactsInSelectedVariant();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getArtifactsForTestCompileType"));
                }
                return collection;
            }
            case ANDROID_TESTS: {
                testArtifact = androidModel.getAndroidTestArtifactInSelectedVariant();
                break;
            }
            case UNIT_TESTS: {
                testArtifact = androidModel.getUnitTestArtifactInSelectedVariant();
            }
        }
        ImmutableList immutableList = testArtifact != null ? ImmutableList.of((Object)testArtifact) : Collections.emptyList();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getArtifactsForTestCompileType"));
        }
        return immutableList;
    }

    private static void addAfterSyncTasks(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull JpsAndroidModuleProperties properties) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "addAfterSyncTasks"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "addAfterSyncTasks"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "addAfterSyncTasks"));
        }
        for (String taskName : properties.AFTER_SYNC_TASK_NAMES) {
            GradleBuildInvoker.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private static void addTaskIfSpecified(@NotNull List<String> tasks, @NotNull String gradlePath, @Nullable String gradleTaskName) {
        String buildTask;
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "addTaskIfSpecified"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "addTaskIfSpecified"));
        }
        if (StringUtil.isNotEmpty((String)gradleTaskName) && !tasks.contains(buildTask = GradleBuildInvoker.createBuildTask(gradlePath, gradleTaskName))) {
            tasks.add(buildTask);
        }
    }

    @NotNull
    public static String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProjectPath", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "createBuildTask"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "createBuildTask"));
        }
        if (gradleProjectPath.equals(":")) {
            String string = gradleProjectPath + taskName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "createBuildTask"));
            }
            return string;
        }
        String string = gradleProjectPath + ":" + taskName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "createBuildTask"));
        }
        return string;
    }

    @NotNull
    public static TestCompileType getTestCompileType(@Nullable String runConfigurationId) {
        if (runConfigurationId != null) {
            if (AndroidCommonUtils.isInstrumentationTestConfiguration((String)runConfigurationId)) {
                TestCompileType testCompileType = TestCompileType.ANDROID_TESTS;
                if (testCompileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getTestCompileType"));
                }
                return testCompileType;
            }
            if (AndroidCommonUtils.isTestConfiguration((String)runConfigurationId)) {
                TestCompileType testCompileType = TestCompileType.UNIT_TESTS;
                if (testCompileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getTestCompileType"));
                }
                return testCompileType;
            }
        }
        TestCompileType testCompileType = TestCompileType.NONE;
        if (testCompileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getTestCompileType"));
        }
        return testCompileType;
    }

    public void stopBuild(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "stopBuild"));
        }
        this.myBuildStopper.attemptToStopBuild(id, null);
    }

    public void add(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "add"));
        }
        this.myAfterTasks.add(task);
    }

    @NotNull
    AfterGradleInvocationTask[] getAfterInvocationTasks() {
        AfterGradleInvocationTask[] afterGradleInvocationTaskArray = this.myAfterTasks.toArray(new AfterGradleInvocationTask[this.myAfterTasks.size()]);
        if (afterGradleInvocationTaskArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getAfterInvocationTasks"));
        }
        return afterGradleInvocationTaskArray;
    }

    public void remove(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "remove"));
        }
        this.myAfterTasks.remove(task);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker", "getProject"));
        }
        return project;
    }

    public static class Request {
        @NotNull
        private final Project myProject;
        @NotNull
        private final List<String> myGradleTasks;
        @NotNull
        private final List<String> myJvmArguments;
        @NotNull
        private final List<String> myCommandLineArguments;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @Nullable
        private ExternalSystemTaskNotificationListener myTaskListener;
        @Nullable
        private File myBuildFilePath;
        private boolean myWaitForCompletion;
        private boolean myUseEmbeddedGradle;

        public Request(@NotNull Project project, String ... gradleTasks) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "<init>"));
            }
            if (gradleTasks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "<init>"));
            }
            this(project, Arrays.asList(gradleTasks));
        }

        public Request(@NotNull Project project, @NotNull List<String> gradleTasks) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "<init>"));
            }
            if (gradleTasks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "<init>"));
            }
            this(project, gradleTasks, ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project));
        }

        public Request(@NotNull Project project, @NotNull List<String> gradleTasks, @NotNull ExternalSystemTaskId taskId) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "<init>"));
            }
            if (gradleTasks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasks", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "<init>"));
            }
            if (taskId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskId", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "<init>"));
            }
            this.myProject = project;
            this.myGradleTasks = new ArrayList<String>(gradleTasks);
            this.myJvmArguments = new ArrayList<String>();
            this.myCommandLineArguments = new ArrayList<String>();
            this.myTaskId = taskId;
        }

        @NotNull
        Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "getProject"));
            }
            return project;
        }

        @NotNull
        List<String> getGradleTasks() {
            List<String> list = this.myGradleTasks;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "getGradleTasks"));
            }
            return list;
        }

        @NotNull
        List<String> getJvmArguments() {
            List<String> list = this.myJvmArguments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "getJvmArguments"));
            }
            return list;
        }

        @NotNull
        public Request setJvmArguments(@NotNull List<String> jvmArguments) {
            if (jvmArguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArguments", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "setJvmArguments"));
            }
            this.myJvmArguments.clear();
            this.myJvmArguments.addAll(jvmArguments);
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "setJvmArguments"));
            }
            return request;
        }

        @NotNull
        List<String> getCommandLineArguments() {
            List<String> list = this.myCommandLineArguments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "getCommandLineArguments"));
            }
            return list;
        }

        @NotNull
        public Request setCommandLineArguments(@NotNull List<String> commandLineArguments) {
            if (commandLineArguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "setCommandLineArguments"));
            }
            this.myCommandLineArguments.clear();
            this.myCommandLineArguments.addAll(commandLineArguments);
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "setCommandLineArguments"));
            }
            return request;
        }

        @Nullable
        public ExternalSystemTaskNotificationListener getTaskListener() {
            return this.myTaskListener;
        }

        @NotNull
        public Request setTaskListener(@Nullable ExternalSystemTaskNotificationListener taskListener) {
            this.myTaskListener = taskListener;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "setTaskListener"));
            }
            return request;
        }

        @NotNull
        ExternalSystemTaskId getTaskId() {
            ExternalSystemTaskId externalSystemTaskId = this.myTaskId;
            if (externalSystemTaskId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "getTaskId"));
            }
            return externalSystemTaskId;
        }

        @Nullable
        File getBuildFilePath() {
            return this.myBuildFilePath;
        }

        @NotNull
        public Request setBuildFilePath(@Nullable File buildFilePath) {
            this.myBuildFilePath = buildFilePath;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "setBuildFilePath"));
            }
            return request;
        }

        boolean isWaitForCompletion() {
            return this.myWaitForCompletion;
        }

        @NotNull
        public Request setWaitForCompletion(boolean waitForCompletion) {
            this.myWaitForCompletion = waitForCompletion;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "setWaitForCompletion"));
            }
            return request;
        }

        boolean isUseEmbeddedGradle() {
            return this.myUseEmbeddedGradle;
        }

        @NotNull
        public Request setUseEmbeddedGradle(boolean useEmbeddedGradle) {
            this.myUseEmbeddedGradle = useEmbeddedGradle;
            Request request = this;
            if (request == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request", "setUseEmbeddedGradle"));
            }
            return request;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return Objects.equals(this.myGradleTasks, that.myGradleTasks) && Objects.equals(this.myJvmArguments, that.myJvmArguments) && Objects.equals(this.myCommandLineArguments, that.myCommandLineArguments);
        }

        public int hashCode() {
            return Objects.hash(this.myGradleTasks, this.myJvmArguments, this.myCommandLineArguments);
        }

        public String toString() {
            return "RequestSettings{myGradleTasks=" + this.myGradleTasks + ", myJvmArguments=" + this.myJvmArguments + ", myCommandLineArguments=" + this.myCommandLineArguments + '}';
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }

    public static enum TestCompileType {
        NONE,
        ANDROID_TESTS,
        UNIT_TESTS;

    }
}

