/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.ide.common.repository.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModelFeatures {
    @Nullable
    private final GradleVersion myModelVersion;
    private final boolean myIssueReportingSupported;
    private final boolean myShadersSupported;
    private final boolean myTestedTargetVariantsSupported;
    private final boolean myProductFlavorVersionSuffixSupported;
    private final boolean myExternalBuildSupported;
    private final boolean myConstraintLayoutSdkLocationSupported;
    private final boolean myLayoutRenderingIssuePresent;

    AndroidModelFeatures(@Nullable GradleVersion modelVersion) {
        this.myModelVersion = modelVersion;
        this.myIssueReportingSupported = this.modelVersionIsAtLeast("1.1.0");
        this.myShadersSupported = this.modelVersionIsAtLeast("2.1.0");
        this.myConstraintLayoutSdkLocationSupported = this.myModelVersion != null && this.myModelVersion.compareTo("2.1.0") > 0;
        this.myProductFlavorVersionSuffixSupported = this.myExternalBuildSupported = this.modelVersionIsAtLeast("2.2.0");
        this.myTestedTargetVariantsSupported = this.myExternalBuildSupported;
        this.myLayoutRenderingIssuePresent = modelVersion != null && modelVersion.getMajor() == 1 && modelVersion.getMinor() == 2 && modelVersion.getMicro() <= 2;
    }

    private boolean modelVersionIsAtLeast(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/android/tools/idea/gradle/project/model/AndroidModelFeatures", "modelVersionIsAtLeast"));
        }
        return this.myModelVersion != null && this.myModelVersion.compareIgnoringQualifiers(revision) >= 0;
    }

    public boolean isIssueReportingSupported() {
        return this.myIssueReportingSupported;
    }

    public boolean isShadersSupported() {
        return this.myShadersSupported;
    }

    public boolean isTestedTargetVariantsSupported() {
        return this.myTestedTargetVariantsSupported;
    }

    public boolean isProductFlavorVersionSuffixSupported() {
        return this.myProductFlavorVersionSuffixSupported;
    }

    public boolean isExternalBuildSupported() {
        return this.myExternalBuildSupported;
    }

    public boolean isConstraintLayoutSdkLocationSupported() {
        return this.myConstraintLayoutSdkLocationSupported;
    }

    public boolean isLayoutRenderingIssuePresent() {
        return this.myLayoutRenderingIssuePresent;
    }
}

