/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncSummary;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class GradleSyncState {
    private static final Logger LOG = Logger.getInstance(GradleSyncState.class);
    private static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"Gradle sync");
    @VisibleForTesting
    static final Topic<GradleSyncListener> GRADLE_SYNC_TOPIC = new Topic("Project sync with Gradle", GradleSyncListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final StateChangeNotification myChangeNotification;
    @NotNull
    private final GradleSyncSummary mySummary;
    @NotNull
    private final GradleFiles myGradleFiles;
    private final Object myLock;
    @GuardedBy(value="myLock")
    private boolean mySyncNotificationsEnabled;
    @GuardedBy(value="myLock")
    private boolean mySyncSkipped;
    @GuardedBy(value="myLock")
    private boolean mySyncInProgress;

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleSyncListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "subscribe"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "subscribe"));
        }
        MessageBusConnection messageBusConnection = GradleSyncState.subscribe(project, listener, (Disposable)project);
        if (messageBusConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "subscribe"));
        }
        return messageBusConnection;
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleSyncListener listener, @NotNull Disposable parentDisposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "subscribe"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "subscribe"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "subscribe"));
        }
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(GRADLE_SYNC_TOPIC, (Object)listener);
        MessageBusConnection messageBusConnection = connection;
        if (messageBusConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "subscribe"));
        }
        return messageBusConnection;
    }

    @NotNull
    public static GradleSyncState getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "getInstance"));
        }
        GradleSyncState gradleSyncState = (GradleSyncState)ServiceManager.getService((Project)project, GradleSyncState.class);
        if (gradleSyncState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "getInstance"));
        }
        return gradleSyncState;
    }

    public GradleSyncState(@NotNull Project project, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleFiles gradleFiles, @NotNull MessageBus messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        if (gradleProjectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProjectInfo", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        if (gradleFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleFiles", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        this(project, gradleProjectInfo, gradleFiles, messageBus, new StateChangeNotification(project), new GradleSyncSummary(project));
    }

    @VisibleForTesting
    GradleSyncState(@NotNull Project project, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleFiles gradleFiles, @NotNull MessageBus messageBus, @NotNull StateChangeNotification changeNotification, @NotNull GradleSyncSummary summary) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        if (gradleProjectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProjectInfo", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        if (gradleFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleFiles", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        if (changeNotification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeNotification", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        if (summary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "summary", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "<init>"));
        }
        this.myLock = new Object();
        this.myProject = project;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myMessageBus = messageBus;
        this.myChangeNotification = changeNotification;
        this.mySummary = summary;
        this.myGradleFiles = gradleFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areSyncNotificationsEnabled() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncNotificationsEnabled;
        }
    }

    public boolean skippedSyncStarted(boolean notifyUser) {
        return this.syncStarted(true, notifyUser);
    }

    public boolean syncStarted(boolean notifyUser) {
        return this.syncStarted(false, notifyUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncStarted(boolean syncSkipped, boolean notifyUser) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySyncInProgress) {
                LOG.info(String.format("Sync already in progress for project '%1$s'.", this.myProject.getName()));
                return false;
            }
            this.mySyncSkipped = syncSkipped;
            this.mySyncInProgress = true;
        }
        LOG.info(String.format("Started sync with Gradle for project '%1$s'.", this.myProject.getName()));
        this.addInfoToEventLog("Gradle sync started");
        if (notifyUser) {
            this.notifyStateChanged();
        }
        this.mySummary.reset();
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncStarted(this.myProject));
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_STARTED);
        UsageTracker.getInstance().log(event);
        return true;
    }

    public void syncSkipped(long lastSyncTimestamp) {
        LOG.info(String.format("Skipped sync with Gradle for project '%1$s'. Project state loaded from cache.", this.myProject.getName()));
        this.stopSyncInProgress();
        this.addInfoToEventLog("Gradle sync completed");
        this.mySummary.setSyncTimestamp(lastSyncTimestamp);
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSkipped(this.myProject));
        this.enableNotifications();
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_SKIPPED);
        UsageTracker.getInstance().log(event);
    }

    public void invalidateLastSync(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "invalidateLastSync"));
        }
        this.syncFailed(error);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            facet.setAndroidModel(null);
        }
    }

    public void syncFailed(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "syncFailed"));
        }
        LOG.info(String.format("Sync with Gradle for project '%1$s' failed: %2$s", this.myProject.getName(), message));
        String logMsg = "Gradle sync failed";
        if (StringUtil.isNotEmpty((String)message)) {
            logMsg = logMsg + String.format(": %1$s", message);
        }
        this.addToEventLog(logMsg, MessageType.ERROR);
        this.syncFinished();
        this.syncPublisher(() -> {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "lambda$syncFailed$2"));
            }
            ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncFailed(this.myProject, message);
        });
        this.mySummary.setSyncErrorsFound(true);
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE);
        UsageTracker.getInstance().log(event);
    }

    public void syncEnded() {
        LOG.info(String.format("Sync with Gradle successful for project '%1$s'.", this.myProject.getName()));
        this.addInfoToEventLog("Gradle sync completed");
        LintUtils.sTryPrefixLookup = true;
        this.syncFinished();
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSucceeded(this.myProject));
        GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(this.myProject);
        String gradleVersionString = gradleVersion != null ? gradleVersion.toString() : "";
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_ENDED).setGradleVersion(gradleVersionString);
        UsageTracker.getInstance().log(event);
    }

    private void addInfoToEventLog(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "addInfoToEventLog"));
        }
        this.addToEventLog(message, MessageType.INFO);
    }

    private void addToEventLog(@NotNull String message, @NotNull MessageType type) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "addToEventLog"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "addToEventLog"));
        }
        LOGGING_NOTIFICATION.createNotification(message, type).notify(this.myProject);
    }

    private void syncFinished() {
        this.stopSyncInProgress();
        this.mySummary.setSyncTimestamp(System.currentTimeMillis());
        this.enableNotifications();
        this.notifyStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSyncInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncInProgress = false;
            this.mySyncSkipped = false;
        }
    }

    private void syncPublisher(@NotNull Runnable publishingTask) {
        if (publishingTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishingTask", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "syncPublisher"));
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)publishingTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableNotifications() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncNotificationsEnabled = true;
        }
    }

    public void notifyStateChanged() {
        this.myChangeNotification.notifyStateChanged();
    }

    public boolean lastSyncFailedOrHasIssues() {
        boolean lastSyncFailed = this.lastSyncFailed();
        boolean hasSyncErrors = this.mySummary.hasSyncErrors();
        return lastSyncFailed || hasSyncErrors;
    }

    public boolean lastSyncFailed() {
        return !this.isSyncInProgress() && this.myGradleProjectInfo.isBuildWithGradle() && (Projects.requiredAndroidModelMissing(this.myProject) || this.mySummary.hasSyncErrors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncSkipped() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncSkipped;
        }
    }

    @NotNull
    public ThreeState isSyncNeeded() {
        long lastSync = this.mySummary.getSyncTimestamp();
        if (lastSync < 0L) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "isSyncNeeded"));
            }
            return threeState;
        }
        ThreeState threeState = this.myGradleFiles.areGradleFilesModified(lastSync) ? ThreeState.YES : ThreeState.NO;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "isSyncNeeded"));
        }
        return threeState;
    }

    @NotNull
    public GradleSyncSummary getSummary() {
        GradleSyncSummary gradleSyncSummary = this.mySummary;
        if (gradleSyncSummary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/GradleSyncState", "getSummary"));
        }
        return gradleSyncSummary;
    }

    public void setupStarted() {
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).setupStarted(this.myProject));
    }

    @VisibleForTesting
    static class StateChangeNotification {
        @NotNull
        private final Project myProject;

        StateChangeNotification(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/GradleSyncState$StateChangeNotification", "<init>"));
            }
            this.myProject = project;
        }

        void notifyStateChanged() {
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> {
                VirtualFile[] files;
                EditorNotifications notifications = EditorNotifications.getInstance((Project)this.myProject);
                for (VirtualFile file : files = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
                    try {
                        notifications.updateNotifications(file);
                    }
                    catch (Throwable e) {
                        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
                        String msg = String.format("Failed to update editor notifications for file '%1$s'", filePath);
                        LOG.info(msg, e);
                    }
                }
                BuildVariantView.getInstance(this.myProject).updateContents();
            });
        }
    }
}

