/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.google.common.collect.ImmutableList;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Component {
    @NotNull
    private final String myName;
    @NotNull
    private final VersionRange myVersionRange;
    @NotNull
    private final List<Component> myRequirements;
    @Nullable
    private final String myFailureMessage;

    Component(@NotNull String name, @NotNull String version, @Nullable String failureMessage) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/sync/compatibility/Component", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/project/sync/compatibility/Component", "<init>"));
        }
        this.myName = name;
        this.myVersionRange = VersionRange.parse(version);
        this.myFailureMessage = failureMessage;
        this.myRequirements = new ArrayList<Component>();
    }

    @NotNull
    String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/Component", "getName"));
        }
        return string;
    }

    @NotNull
    VersionRange getVersionRange() {
        VersionRange versionRange = this.myVersionRange;
        if (versionRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/Component", "getVersionRange"));
        }
        return versionRange;
    }

    @Nullable
    String getFailureMessage() {
        return this.myFailureMessage;
    }

    @NotNull
    List<Component> getRequirements() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myRequirements);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/Component", "getRequirements"));
        }
        return immutableList;
    }

    void addRequirement(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/gradle/project/sync/compatibility/Component", "addRequirement"));
        }
        this.myRequirements.add(component);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.myName).append(" ").append(this.myVersionRange);
        if (!this.myRequirements.isEmpty()) {
            String lineSeparator = SystemProperties.getLineSeparator();
            buffer.append(lineSeparator).append("Requirements:");
            for (Component requirement : this.myRequirements) {
                buffer.append(lineSeparator).append("  ").append(requirement);
            }
        }
        return buffer.toString();
    }
}

