/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.google.common.base.Splitter;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaHeapSpaceErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        if (rootCause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCause", "com/android/tools/idea/gradle/project/sync/errors/JavaHeapSpaceErrorHandler", "findErrorMessage"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/JavaHeapSpaceErrorHandler", "findErrorMessage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/JavaHeapSpaceErrorHandler", "findErrorMessage"));
        }
        String text = rootCause.getMessage();
        List message = Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text);
        int lineCount = message.size();
        String firstLine = (String)message.get(0);
        String newMsg = null;
        if (StringUtil.isNotEmpty((String)firstLine) && firstLine.endsWith("Java heap space")) {
            newMsg = firstLine + ".";
        } else if (StringUtil.isNotEmpty((String)firstLine) && lineCount > 1 && firstLine.startsWith("Unable to start the daemon process")) {
            String cause = null;
            for (int i = 1; i < lineCount; ++i) {
                String line = (String)message.get(i);
                if (!"Error occurred during initialization of VM".equals(line) || i >= lineCount - 1) continue;
                cause = (String)message.get(i + 1);
                break;
            }
            if (cause != null && cause.startsWith("Could not reserve enough space for object heap")) {
                firstLine = StringUtil.trimEnd((String)firstLine, (String)".");
                if (!cause.endsWith(".")) {
                    cause = cause + ".";
                }
                newMsg = firstLine + ": " + StringUtil.decapitalize((String)cause);
            }
        }
        if (StringUtil.isNotEmpty(newMsg)) {
            newMsg = newMsg + "\nPlease assign more memory to Gradle in the project's gradle.properties file.\nFor example, the following line, in the gradle.properties file, sets the maximum Java heap size to 1,024 MB:\n<em>org.gradle.jvmargs=-Xmx1024m</em>";
            if (rootCause instanceof OutOfMemoryError) {
                newMsg = "Out of memory: " + newMsg;
                JavaHeapSpaceErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.OUT_OF_MEMORY);
            } else {
                JavaHeapSpaceErrorHandler.updateUsageTracker();
            }
            return newMsg;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/errors/JavaHeapSpaceErrorHandler", "getQuickFixHyperlinks"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/errors/JavaHeapSpaceErrorHandler", "getQuickFixHyperlinks"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/errors/JavaHeapSpaceErrorHandler", "getQuickFixHyperlinks"));
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new OpenUrlHyperlink("http://www.gradle.org/docs/current/userguide/build_environment.html", "Read Gradle's configuration guide"));
        hyperlinks.add(new OpenUrlHyperlink("http://docs.oracle.com/javase/7/docs/technotes/guides/vm/gc-ergonomics.html", "Read about Java's heap size"));
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/errors/JavaHeapSpaceErrorHandler", "getQuickFixHyperlinks"));
        }
        return arrayList;
    }
}

