/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class InstallRepositoryHyperlink
extends NotificationHyperlink {
    @NotNull
    private final SdkMavenRepository myRepository;

    public InstallRepositoryHyperlink(@NotNull SdkMavenRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallRepositoryHyperlink", "<init>"));
        }
        super("install.m2.repo", "Install Repository and sync project");
        this.myRepository = repository;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallRepositoryHyperlink", "execute"));
        }
        ArrayList requested = Lists.newArrayList();
        requested.add(this.myRepository.getPackageId());
        ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog != null) {
            dialog.setTitle("Install Missing Components");
            if (dialog.showAndGet()) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public SdkMavenRepository getRepository() {
        SdkMavenRepository sdkMavenRepository = this.myRepository;
        if (sdkMavenRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/hyperlink/InstallRepositoryHyperlink", "getRepository"));
        }
        return sdkMavenRepository;
    }
}

