/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.SdkSync;
import com.android.tools.idea.gradle.project.sync.precheck.AndroidStudioSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

class AndroidSdkPreSyncCheck
extends AndroidStudioSyncCheck {
    @NotNull
    private final SdkSync mySdkSync;

    AndroidSdkPreSyncCheck() {
        this(SdkSync.getInstance());
    }

    @VisibleForTesting
    AndroidSdkPreSyncCheck(@NotNull SdkSync sdkSync) {
        if (sdkSync == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkSync", "com/android/tools/idea/gradle/project/sync/precheck/AndroidSdkPreSyncCheck", "<init>"));
        }
        this.mySdkSync = sdkSync;
    }

    @Override
    @NotNull
    PreSyncCheckResult doCheckCanSync(@NotNull Project project) {
        PreSyncCheckResult preSyncCheckResult;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/precheck/AndroidSdkPreSyncCheck", "doCheckCanSync"));
        }
        try {
            this.mySdkSync.syncIdeAndProjectAndroidSdks(project);
            preSyncCheckResult = PreSyncCheckResult.SUCCESS;
        }
        catch (Throwable e) {
            String msg = "Failed to sync SDKs";
            PreSyncCheckResult preSyncCheckResult2 = PreSyncCheckResult.failure(msg);
            if (preSyncCheckResult2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/AndroidSdkPreSyncCheck", "doCheckCanSync"));
            }
            return preSyncCheckResult2;
        }
        if (preSyncCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/AndroidSdkPreSyncCheck", "doCheckCanSync"));
        }
        return preSyncCheckResult;
    }
}

