/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.project.sync.precheck.SyncCheck;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

abstract class AndroidStudioSyncCheck
extends SyncCheck {
    AndroidStudioSyncCheck() {
    }

    @Override
    @NotNull
    final PreSyncCheckResult canSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/precheck/AndroidStudioSyncCheck", "canSync"));
        }
        if (IdeInfo.getInstance().isAndroidStudio()) {
            PreSyncCheckResult preSyncCheckResult = this.doCheckCanSync(project);
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/AndroidStudioSyncCheck", "canSync"));
            }
            return preSyncCheckResult;
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.SUCCESS;
        if (preSyncCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/AndroidStudioSyncCheck", "canSync"));
        }
        return preSyncCheckResult;
    }

    @VisibleForTesting
    @NotNull
    abstract PreSyncCheckResult doCheckCanSync(@NotNull Project var1);
}

