/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Facets {
    private Facets() {
    }

    @SafeVarargs
    public static <T extends Facet> void removeAllFacets(@NotNull ModifiableFacetModel facetModel, FacetTypeId<T> ... typeIds) {
        if (facetModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetModel", "com/android/tools/idea/gradle/project/sync/setup/Facets", "removeAllFacets"));
        }
        if (typeIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeIds", "com/android/tools/idea/gradle/project/sync/setup/Facets", "removeAllFacets"));
        }
        for (FacetTypeId<T> typeId : typeIds) {
            Collection facets = facetModel.getFacetsByType(typeId);
            for (Facet facet : facets) {
                facetModel.removeFacet(facet);
            }
        }
    }

    @Nullable
    public static <T extends Facet> T findFacet(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull FacetTypeId<T> typeId) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/Facets", "findFacet"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/sync/setup/Facets", "findFacet"));
        }
        if (typeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeId", "com/android/tools/idea/gradle/project/sync/setup/Facets", "findFacet"));
        }
        ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(module);
        return (T)facetModel.getFacetByType(typeId);
    }
}

