/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.java;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.SyncAction;
import com.android.tools.idea.gradle.project.sync.setup.module.JavaModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.common.CompilerSettingsSetup;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class CompilerOutputModuleSetupStep
extends JavaModuleSetupStep {
    @NonNls
    private static final String CLASSES_FOLDER_NAME = "classes";
    private final CompilerSettingsSetup myCompilerSettingsSetup = new CompilerSettingsSetup();

    @Override
    protected void doSetUpModule(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull JavaModuleModel javaModuleModel, @Nullable SyncAction.ModuleModels gradleModels, @Nullable ProgressIndicator indicator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/setup/module/java/CompilerOutputModuleSetupStep", "doSetUpModule"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/java/CompilerOutputModuleSetupStep", "doSetUpModule"));
        }
        if (javaModuleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModuleModel", "com/android/tools/idea/gradle/project/sync/setup/module/java/CompilerOutputModuleSetupStep", "doSetUpModule"));
        }
        File mainClassesFolder = null;
        File testClassesFolder = null;
        ExtIdeaCompilerOutput compilerOutput = javaModuleModel.getCompilerOutput();
        if (compilerOutput == null) {
            File buildFolderPath = javaModuleModel.getBuildFolderPath();
            if (buildFolderPath != null) {
                mainClassesFolder = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, "main"}));
                testClassesFolder = new File(buildFolderPath, FileUtil.join((String[])new String[]{CLASSES_FOLDER_NAME, "test"}));
            }
        } else {
            mainClassesFolder = compilerOutput.getMainClassesDir();
            testClassesFolder = compilerOutput.getTestClassesDir();
        }
        if (mainClassesFolder != null) {
            ModifiableRootModel moduleModel = ideModelsProvider.getModifiableRootModel(module);
            this.myCompilerSettingsSetup.setOutputPaths(moduleModel, mainClassesFolder, testClassesFolder);
        }
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Compiler output setup" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/module/java/CompilerOutputModuleSetupStep", "getDescription"));
        }
        return "Compiler output setup";
    }
}

