/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Calendar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpiredPreviewBuildSetupStep
extends ProjectSetupStep {
    @NotNull
    private final ApplicationInfo myApplicationInfo;
    private volatile boolean myExpirationChecked;

    public ExpiredPreviewBuildSetupStep() {
        this(ApplicationInfo.getInstance());
    }

    public ExpiredPreviewBuildSetupStep(@NotNull ApplicationInfo applicationInfo) {
        if (applicationInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationInfo", "com/android/tools/idea/gradle/project/sync/setup/post/project/ExpiredPreviewBuildSetupStep", "<init>"));
        }
        this.myApplicationInfo = applicationInfo;
    }

    @Override
    public void setUpProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/project/ExpiredPreviewBuildSetupStep", "setUpProject"));
        }
        if (this.myExpirationChecked) {
            return;
        }
        String ideVersion = this.myApplicationInfo.getFullVersion();
        if (ExpiredPreviewBuildSetupStep.isPreview(ideVersion)) {
            Calendar expirationDate = (Calendar)this.myApplicationInfo.getBuildDate().clone();
            expirationDate.add(2, 2);
            Calendar now = Calendar.getInstance();
            if (now.after(expirationDate)) {
                String message = String.format("This preview build (%1$s) is old; please update to a newer preview or a stable version.", ideVersion);
                OpenUrlHyperlink hyperlink = new OpenUrlHyperlink("http://tools.android.com/download/studio/", "Show Available Versions");
                AndroidGradleNotification.getInstance(project).showBalloon("Old Preview Build", message, NotificationType.INFORMATION, hyperlink);
                this.myExpirationChecked = true;
            }
        }
    }

    private static boolean isPreview(@NotNull String ideVersion) {
        if (ideVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideVersion", "com/android/tools/idea/gradle/project/sync/setup/post/project/ExpiredPreviewBuildSetupStep", "isPreview"));
        }
        return ideVersion.contains("Preview") || ideVersion.contains("Beta") || ideVersion.contains("RC");
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }

    @VisibleForTesting
    boolean isExpirationChecked() {
        return this.myExpirationChecked;
    }
}

