/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.gradle.project.sync.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.pom.NonNavigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingPlatformsSetupStep
extends ProjectSetupStep {
    @Override
    public void setUpProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/project/MissingPlatformsSetupStep", "setUpProject"));
        }
        SyncMessages syncMessages = SyncMessages.getInstance(project);
        int sdkErrorCount = syncMessages.getMessageCount("SDK Setup Issues");
        if (sdkErrorCount > 0) {
            String text = "Open Android SDK Manager and install all missing platforms.";
            SyncMessage hint = new SyncMessage("SDK Setup Issues", MessageType.INFO, NonNavigatable.INSTANCE, text);
            hint.add(new OpenAndroidSdkManagerHyperlink());
            syncMessages.report(hint);
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }
}

