/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.repository.Revision;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkToolsVersionSetupStep
extends ProjectSetupStep {
    @NotNull
    private final IdeSdks myIdeSdks;
    private volatile boolean myNewSdkVersionToolsInfoAlreadyShown;

    public SdkToolsVersionSetupStep() {
        this(IdeSdks.getInstance());
    }

    @VisibleForTesting
    SdkToolsVersionSetupStep(@NotNull IdeSdks ideSdks) {
        if (ideSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideSdks", "com/android/tools/idea/gradle/project/sync/setup/post/project/SdkToolsVersionSetupStep", "<init>"));
        }
        this.myIdeSdks = ideSdks;
    }

    @Override
    public void setUpProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/project/SdkToolsVersionSetupStep", "setUpProject"));
        }
        if (this.myNewSdkVersionToolsInfoAlreadyShown) {
            return;
        }
        File androidHome = this.myIdeSdks.getAndroidSdkPath();
        if (androidHome != null && !VersionCheck.isCompatibleVersion(androidHome)) {
            InstallSdkToolsHyperlink hyperlink = new InstallSdkToolsHyperlink(VersionCheck.MIN_TOOLS_REV);
            String message = "Version " + VersionCheck.MIN_TOOLS_REV + " or later is required.";
            AndroidGradleNotification.getInstance(project).showBalloon("Android SDK Tools", message, NotificationType.INFORMATION, hyperlink);
            this.myNewSdkVersionToolsInfoAlreadyShown = true;
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }

    @VisibleForTesting
    boolean isNewSdkVersionToolsInfoAlreadyShown() {
        return this.myNewSdkVersionToolsInfoAlreadyShown;
    }

    @VisibleForTesting
    static class InstallSdkToolsHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Revision myVersion;

        InstallSdkToolsHyperlink(@NotNull Revision version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/project/sync/setup/post/project/SdkToolsVersionSetupStep$InstallSdkToolsHyperlink", "<init>"));
            }
            super("install.sdk.tools", "Install latest SDK Tools");
            this.myVersion = version;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/post/project/SdkToolsVersionSetupStep$InstallSdkToolsHyperlink", "execute"));
            }
            ArrayList requested = Lists.newArrayList();
            if (this.myVersion.getMajor() == 23) {
                Revision minBuildToolsRev = new Revision(20, 0, 0);
                requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
            }
            requested.add("tools");
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
            if (dialog != null && dialog.showAndGet()) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
            }
        }

        @VisibleForTesting
        @NotNull
        Revision getVersion() {
            Revision revision = this.myVersion;
            if (revision == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/project/SdkToolsVersionSetupStep$InstallSdkToolsHyperlink", "getVersion"));
            }
            return revision;
        }
    }
}

