/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsParsedDependencies {
    @NotNull
    private final Multimap<String, ModuleDependencyModel> myParsedModuleDependencies = ArrayListMultimap.create();
    @NotNull
    private final Multimap<String, ArtifactDependencyModel> myParsedArtifactDependencies = ArrayListMultimap.create();

    public PsParsedDependencies(@Nullable GradleBuildModel parsedModel) {
        this.reset(parsedModel);
    }

    void reset(@Nullable GradleBuildModel parsedModel) {
        this.myParsedArtifactDependencies.clear();
        this.myParsedModuleDependencies.clear();
        if (parsedModel != null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                for (DependencyModel parsedDependency : parsedModel.dependencies().all()) {
                    if (parsedDependency instanceof ArtifactDependencyModel) {
                        ArtifactDependencyModel artifact = (ArtifactDependencyModel)parsedDependency;
                        this.myParsedArtifactDependencies.put((Object)PsParsedDependencies.createIdFrom(artifact), (Object)artifact);
                        continue;
                    }
                    if (!(parsedDependency instanceof ModuleDependencyModel)) continue;
                    ModuleDependencyModel module = (ModuleDependencyModel)parsedDependency;
                    this.myParsedModuleDependencies.put((Object)module.path().value(), (Object)module);
                }
            });
        }
    }

    @NotNull
    private static String createIdFrom(@NotNull ArtifactDependencyModel dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "createIdFrom"));
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{(String)dependency.group().value(), dependency.name().value()});
        String string = PsParsedDependencies.joinAsGradlePath(segments);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "createIdFrom"));
        }
        return string;
    }

    @NotNull
    public List<ArtifactDependencyModel> findLibraryDependencies(@NotNull PsArtifactDependencySpec spec, @Nullable Predicate<ArtifactDependencyModel> predicate) {
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "findLibraryDependencies"));
        }
        String id = PsParsedDependencies.createIdFrom(spec);
        Collection potentialMatches = this.myParsedArtifactDependencies.get((Object)id);
        if (predicate != null) {
            List<ArtifactDependencyModel> list = potentialMatches.stream().filter(predicate).collect(Collectors.toList());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "findLibraryDependencies"));
            }
            return list;
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)potentialMatches);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "findLibraryDependencies"));
        }
        return immutableList;
    }

    @NotNull
    private static String createIdFrom(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "createIdFrom"));
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{spec.group, spec.name});
        String string = PsParsedDependencies.joinAsGradlePath(segments);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "createIdFrom"));
        }
        return string;
    }

    @Nullable
    public ArtifactDependencyModel findLibraryDependency(@NotNull MavenCoordinates coordinates, @NotNull Predicate<ArtifactDependencyModel> predicate) {
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "findLibraryDependency"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "findLibraryDependency"));
        }
        Collection potentialMatches = this.myParsedArtifactDependencies.get((Object)PsParsedDependencies.createIdFrom(coordinates));
        for (ArtifactDependencyModel dependency : potentialMatches) {
            if (!predicate.test(dependency)) continue;
            return dependency;
        }
        return null;
    }

    @NotNull
    private static String createIdFrom(@NotNull MavenCoordinates coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "createIdFrom"));
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{coordinates.getGroupId(), coordinates.getArtifactId()});
        String string = PsParsedDependencies.joinAsGradlePath(segments);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "createIdFrom"));
        }
        return string;
    }

    @Nullable
    public ArtifactDependencyModel findLibraryDependency(@NotNull GradleModuleVersion moduleVersion) {
        GradleVersion parsedVersion;
        if (moduleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleVersion", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "findLibraryDependency"));
        }
        Collection potentialMatches = this.myParsedArtifactDependencies.get((Object)PsParsedDependencies.createIdFrom(moduleVersion));
        if (potentialMatches.size() == 1) {
            return (ArtifactDependencyModel)ContainerUtil.getFirstItem((Collection)potentialMatches);
        }
        String version = Strings.nullToEmpty((String)moduleVersion.getVersion());
        HashMap dependenciesByVersion = Maps.newHashMap();
        for (ArtifactDependencyModel potentialMatch : potentialMatches) {
            GradleVersion parsedVersion2;
            String potentialVersion = Strings.nullToEmpty((String)((String)potentialMatch.version().value()));
            if (version.equals(potentialVersion)) {
                return potentialMatch;
            }
            if (!StringUtil.isNotEmpty((String)potentialVersion) || (parsedVersion2 = GradleVersion.tryParse((String)potentialVersion)) == null) continue;
            dependenciesByVersion.put(parsedVersion2, potentialMatch);
        }
        if (StringUtil.isNotEmpty((String)version) && !dependenciesByVersion.isEmpty() && (parsedVersion = GradleVersion.tryParse((String)version)) != null) {
            for (String potentialVersion : dependenciesByVersion.keySet()) {
                if (parsedVersion.compareTo((GradleVersion)potentialVersion) <= 0) continue;
                return (ArtifactDependencyModel)dependenciesByVersion.get(potentialVersion);
            }
        }
        return null;
    }

    @NotNull
    private static String createIdFrom(@NotNull GradleModuleVersion moduleVersion) {
        if (moduleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleVersion", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "createIdFrom"));
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{moduleVersion.getGroup(), moduleVersion.getName()});
        String string = PsParsedDependencies.joinAsGradlePath(segments);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "createIdFrom"));
        }
        return string;
    }

    @NotNull
    private static String joinAsGradlePath(@NotNull List<String> segments) {
        if (segments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segments", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "joinAsGradlePath"));
        }
        String string = Joiner.on((String)":").skipNulls().join(segments);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "joinAsGradlePath"));
        }
        return string;
    }

    @Nullable
    public ModuleDependencyModel findModuleDependency(@NotNull String gradlePath, @NotNull Predicate<ModuleDependencyModel> predicate) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "findModuleDependency"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/android/tools/idea/gradle/structure/model/PsParsedDependencies", "findModuleDependency"));
        }
        Collection potentialMatches = this.myParsedModuleDependencies.get((Object)gradlePath);
        for (ModuleDependencyModel dependency : potentialMatches) {
            if (!predicate.test(dependency)) continue;
            return dependency;
        }
        return null;
    }
}

