/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.SdkConstants;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleLocalCache;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleUtil {
    public static final ProjectSystemId GRADLE_SYSTEM_ID = GradleConstants.SYSTEM_ID;
    @NonNls
    public static final String BUILD_DIR_DEFAULT_NAME = "build";
    @NonNls
    public static final String GRADLEW_PROPERTIES_PATH = FileUtil.join((String[])new String[]{SdkConstants.FD_GRADLE_WRAPPER, "gradle-wrapper.properties"});
    private static final Logger LOG = Logger.getInstance(GradleUtil.class);
    private static final CharMatcher ILLEGAL_GRADLE_PATH_CHARS_MATCHER = CharMatcher.anyOf((CharSequence)"\\/");

    private GradleUtil() {
    }

    @NotNull
    public static Collection<File> getGeneratedSourceFolders(@NotNull BaseArtifact artifact) {
        List<File> list;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/util/GradleUtil", "getGeneratedSourceFolders"));
        }
        try {
            List<File> folders = artifact.getGeneratedSourceFolders();
            list = folders != null ? folders : Collections.emptyList();
        }
        catch (UnsupportedMethodException unsupportedMethodException) {
            List<File> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGeneratedSourceFolders"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGeneratedSourceFolders"));
        }
        return list;
    }

    @NotNull
    public static Dependencies getDependencies(@NotNull BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/util/GradleUtil", "getDependencies"));
        }
        Dependencies dependencies = artifact.getDependencies();
        if (dependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDependencies"));
        }
        return dependencies;
    }

    public static boolean androidModelSupportsInstantApps(@NotNull GradleVersion modelVersion) {
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/idea/gradle/util/GradleUtil", "androidModelSupportsInstantApps"));
        }
        return modelVersion.compareIgnoringQualifiers("2.3.0") >= 0;
    }

    public static void clearStoredGradleJvmArgs(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "clearStoredGradleJvmArgs"));
        }
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        String existingJvmArgs = settings.getGradleVmOptions();
        settings.setGradleVmOptions(null);
        if (!StringUtil.isEmptyOrSpaces((String)existingJvmArgs)) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "lambda$clearStoredGradleJvmArgs$0"));
                }
                String jvmArgs = existingJvmArgs.trim();
                String msg = String.format("Starting with version 1.3, Android Studio no longer supports IDE-specific Gradle JVM arguments.\n\nAndroid Studio will now remove any stored Gradle JVM arguments.\n\nWould you like to copy these JVM arguments:\n%1$s\nto the project's gradle.properties file?\n\n(Any existing JVM arguments in the gradle.properties file will be overwritten.)", jvmArgs);
                int result = Messages.showYesNoDialog((Project)project, (String)msg, (String)"Gradle Settings", (Icon)Messages.getQuestionIcon());
                if (result == 0) {
                    try {
                        GradleProperties gradleProperties = new GradleProperties(project);
                        gradleProperties.setJvmArgs(jvmArgs);
                        gradleProperties.save();
                    }
                    catch (IOException e) {
                        String err = String.format("Failed to copy JVM arguments '%1$s' to the project's gradle.properties file.", existingJvmArgs);
                        LOG.info(err, (Throwable)e);
                        String cause = e.getMessage();
                        if (StringUtil.isNotEmpty((String)cause)) {
                            err = err + String.format("<br>\nCause: %1$s", cause);
                        }
                        AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", err, NotificationType.ERROR);
                    }
                } else {
                    String text = String.format("JVM arguments<br>\n'%1$s'<br>\nwere not copied to the project's gradle.properties file.", existingJvmArgs);
                    AndroidGradleNotification.getInstance(project).showBalloon("Gradle Settings", text, NotificationType.WARNING);
                }
            });
        }
    }

    public static boolean isSupportedGradleVersion(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "isSupportedGradleVersion"));
        }
        GradleVersion supported = GradleVersion.parse((String)"3.3");
        return supported.compareTo(gradleVersion) <= 0;
    }

    @Deprecated
    @NotNull
    public static AndroidArtifactOutput getOutput(@NotNull AndroidArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/util/GradleUtil", "getOutput"));
        }
        Collection outputs = artifact.getOutputs();
        assert (!outputs.isEmpty());
        AndroidArtifactOutput output = (AndroidArtifactOutput)ContainerUtil.getFirstItem((Collection)outputs);
        assert (output != null);
        AndroidArtifactOutput androidArtifactOutput = output;
        if (androidArtifactOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getOutput"));
        }
        return androidArtifactOutput;
    }

    @NotNull
    public static Icon getModuleIcon(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel != null) {
            int projectType = androidModel.getProjectType();
            if (projectType == 0 || projectType == 4) {
                Icon icon = AndroidIcons.AppModule;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
                }
                return icon;
            }
            Icon icon = AndroidIcons.LibraryModule;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
            }
            return icon;
        }
        Icon icon = AndroidProjectInfo.getInstance(module.getProject()).requiresAndroidModel() ? AllIcons.Nodes.PpJdk : AllIcons.Nodes.Module;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleIcon"));
        }
        return icon;
    }

    @Nullable
    public static AndroidProject getAndroidProject(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getAndroidProject"));
        }
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        return gradleModel != null ? gradleModel.getAndroidProject() : null;
    }

    @Nullable
    public static NativeAndroidProject getNativeAndroidProject(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getNativeAndroidProject"));
        }
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(module);
        return ndkModuleModel != null ? ndkModuleModel.getAndroidProject() : null;
    }

    @Nullable
    public static String getGradlePath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getGradlePath"));
        }
        GradleFacet facet = GradleFacet.getInstance(module);
        return facet != null ? ((GradleFacetConfiguration)facet.getConfiguration()).GRADLE_PROJECT_PATH : null;
    }

    public static boolean isRootModuleWithNoSources(@NotNull Module module) {
        String gradlePath;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "isRootModuleWithNoSources"));
        }
        return ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0 && ((gradlePath = GradleUtil.getGradlePath(module)) == null || gradlePath.equals(":"));
    }

    @NotNull
    public static List<AndroidLibrary> getDirectLibraryDependencies(@NotNull Variant variant, @NotNull AndroidModuleModel androidModel) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        ArrayList libraries = Lists.newArrayList();
        GradleVersion modelVersion = androidModel.getModelVersion();
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        Dependencies dependencies = GradleUtil.getDependencies((BaseArtifact)mainArtifact, modelVersion);
        libraries.addAll(dependencies.getLibraries());
        for (BaseArtifact testArtifact : AndroidModuleModel.getTestArtifacts(variant)) {
            dependencies = GradleUtil.getDependencies(testArtifact, modelVersion);
            libraries.addAll(dependencies.getLibraries());
        }
        ArrayList arrayList = libraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDirectLibraryDependencies"));
        }
        return arrayList;
    }

    @Nullable
    public static Module findModuleByGradlePath(@NotNull Project project, @NotNull String gradlePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "findModuleByGradlePath"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "findModuleByGradlePath"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet == null || !gradlePath.equals(((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH)) continue;
            return module;
        }
        return null;
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getPathSegments"));
        }
        List list = Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)gradlePath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getPathSegments"));
        }
        return list;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFile"));
        }
        GradleFacet gradleFacet = GradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleModuleModel() != null) {
            return gradleFacet.getGradleModuleModel().getBuildFile();
        }
        File moduleFilePath = new File(module.getModuleFilePath());
        File parentFile = moduleFilePath.getParentFile();
        return parentFile != null ? GradleUtil.getGradleBuildFile(parentFile) : null;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFile"));
        }
        File gradleBuildFilePath = GradleUtil.getGradleBuildFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleBuildFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleBuildFilePath(@NotNull File dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFilePath"));
        }
        File file = new File(dirPath, "build.gradle");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleBuildFilePath"));
        }
        return file;
    }

    @Nullable
    public static VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFile"));
        }
        File gradleSettingsFilePath = GradleUtil.getGradleSettingsFilePath(dirPath);
        return VfsUtil.findFileByIoFile((File)gradleSettingsFilePath, (boolean)true);
    }

    @NotNull
    public static File getGradleSettingsFilePath(@NotNull File dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFilePath"));
        }
        File file = new File(dirPath, "settings.gradle");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleSettingsFilePath"));
        }
        return file;
    }

    @Nullable
    public static GradleExecutionSettings getOrCreateGradleExecutionSettings(@NotNull Project project, boolean useEmbeddedGradle) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getOrCreateGradleExecutionSettings"));
        }
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(project);
        if (IdeInfo.getInstance().isAndroidStudio() && useEmbeddedGradle && executionSettings == null) {
            File gradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath();
            assert (gradlePath != null && gradlePath.isDirectory());
            executionSettings = new GradleExecutionSettings(gradlePath.getPath(), null, DistributionType.LOCAL, null, false);
            File jdkPath = IdeSdks.getInstance().getJdkPath();
            if (jdkPath != null) {
                executionSettings.setJavaHome(jdkPath.getPath());
            }
        }
        return executionSettings;
    }

    @Nullable
    public static GradleExecutionSettings getGradleExecutionSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleExecutionSettings"));
        }
        GradleProjectSettings projectSettings = GradleUtil.getGradleProjectSettings(project);
        if (projectSettings == null) {
            File baseDirPath = Projects.getBaseDirPath(project);
            String msg = String.format("Unable to obtain Gradle project settings for project '%1$s', located at '%2$s'", project.getName(), baseDirPath.getPath());
            LOG.info(msg);
            return null;
        }
        try {
            return (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectSettings.getExternalProjectPath(), (ProjectSystemId)GRADLE_SYSTEM_ID);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Failed to obtain Gradle execution settings", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static GradleProjectSettings getGradleProjectSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getGradleProjectSettings"));
        }
        return GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
    }

    @VisibleForTesting
    @Nullable
    static String getGradleInvocationJvmArg(@Nullable BuildMode buildMode) {
        if (BuildMode.ASSEMBLE_TRANSLATE == buildMode) {
            return AndroidGradleSettings.createJvmArg((String)"enableTranslation", (boolean)true);
        }
        return null;
    }

    public static void stopAllGradleDaemonsAndRestart() {
        DefaultGradleConnector.close();
        Application application = ApplicationManager.getApplication();
        if (application instanceof ApplicationImpl) {
            ((ApplicationImpl)application).restart(true);
        } else {
            application.restart();
        }
    }

    @NotNull
    public static String getDefaultPhysicalPathFromGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultPhysicalPathFromGradlePath"));
        }
        List<String> segments = GradleUtil.getPathSegments(gradlePath);
        String string = FileUtil.join((String[])ArrayUtil.toStringArray(segments));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getDefaultPhysicalPathFromGradlePath"));
        }
        return string;
    }

    @NotNull
    public static File getModuleDefaultPath(@NotNull VirtualFile parentDir, @NotNull String gradlePath) {
        if (parentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDir", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleDefaultPath"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleDefaultPath"));
        }
        assert (gradlePath.length() > 0);
        String relativePath = GradleUtil.getDefaultPhysicalPathFromGradlePath(gradlePath);
        File file = new File(VfsUtilCore.virtualToIoFile((VirtualFile)parentDir), relativePath);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleUtil", "getModuleDefaultPath"));
        }
        return file;
    }

    public static int isValidGradlePath(@NotNull String gradlePath) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "isValidGradlePath"));
        }
        return ILLEGAL_GRADLE_PATH_CHARS_MATCHER.indexIn((CharSequence)gradlePath);
    }

    public static boolean hasModule(@Nullable Project project, @NotNull String gradlePath, boolean checkProjectFolder) {
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/util/GradleUtil", "hasModule"));
        }
        if (project == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!gradlePath.equals(GradleUtil.getGradlePath(module))) continue;
            return true;
        }
        if (checkProjectFolder) {
            File location = GradleUtil.getModuleDefaultPath(project.getBaseDir(), gradlePath);
            if (location.isFile()) {
                return true;
            }
            if (location.isDirectory()) {
                File[] children = location.listFiles();
                return children == null || children.length > 0;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public static GradleVersion getAndroidGradleModelVersionInUse(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "getAndroidGradleModelVersionInUse"));
        }
        HashSet foundInLibraries = Sets.newHashSet();
        HashSet foundInApps = Sets.newHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            AndroidProject androidProject = androidModel.getAndroidProject();
            String modelVersion = androidProject.getModelVersion();
            if (androidModel.getProjectType() == 0) {
                foundInApps.add(modelVersion);
                continue;
            }
            foundInLibraries.add(modelVersion);
        }
        String found = null;
        if (foundInApps.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInApps);
        } else if (foundInApps.isEmpty() && foundInLibraries.size() == 1) {
            found = (String)Iterables.getOnlyElement((Iterable)foundInLibraries);
        }
        return found != null ? GradleVersion.tryParse((String)found) : null;
    }

    public static void attemptToUseEmbeddedGradle(@NotNull Project project) {
        GradleWrapper gradleWrapper;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "attemptToUseEmbeddedGradle"));
        }
        if (IdeInfo.getInstance().isAndroidStudio() && (gradleWrapper = GradleWrapper.find(project)) != null) {
            GradleProjectSettings gradleSettings;
            File embeddedGradlePath;
            String gradleVersion = null;
            try {
                Properties properties = gradleWrapper.getProperties();
                String url = properties.getProperty("distributionUrl");
                gradleVersion = GradleUtil.getGradleWrapperVersionOnlyIfComingForGradleDotOrg(url);
            }
            catch (IOException e) {
                LOG.warn("Failed to read file " + gradleWrapper.getPropertiesFilePath().getPath());
            }
            if (gradleVersion != null && GradleUtil.isCompatibleWithEmbeddedGradleVersion(gradleVersion) && !GradleLocalCache.getInstance().containsGradleWrapperVersion(gradleVersion, project) && (embeddedGradlePath = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionPath()) != null && (gradleSettings = GradleUtil.getGradleProjectSettings(project)) != null) {
                gradleSettings.setDistributionType(DistributionType.LOCAL);
                gradleSettings.setGradleHome(embeddedGradlePath.getPath());
            }
        }
    }

    @VisibleForTesting
    @Nullable
    static String getGradleWrapperVersionOnlyIfComingForGradleDotOrg(@Nullable String url) {
        String version;
        String expectedPrefix;
        String protocol;
        int foundIndex;
        if (url != null && (foundIndex = url.indexOf("://")) != -1 && ((protocol = url.substring(0, foundIndex)).equals("http") || protocol.equals("https")) && url.startsWith(expectedPrefix = protocol + "://services.gradle.org/distributions/gradle-") && (foundIndex = url.indexOf(45, expectedPrefix.length())) != -1 && StringUtil.isNotEmpty((String)(version = url.substring(expectedPrefix.length(), foundIndex)))) {
            return version;
        }
        return null;
    }

    private static boolean isCompatibleWithEmbeddedGradleVersion(@NotNull String gradleVersion) {
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "com/android/tools/idea/gradle/util/GradleUtil", "isCompatibleWithEmbeddedGradleVersion"));
        }
        return gradleVersion.equals("3.3") || gradleVersion.equals("3.3");
    }

    public static boolean dependsOn(AndroidModuleModel androidModel, String artifact) {
        Dependencies dependencies = androidModel.getSelectedMainCompileDependencies();
        return GradleUtil.dependsOn(dependencies, artifact);
    }

    @Nullable
    public static GradleVersion getModuleDependencyVersion(AndroidModuleModel androidModel, String artifact) {
        Dependencies dependencies = androidModel.getSelectedMainCompileDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            String version = GradleUtil.getDependencyVersion(library, artifact, true);
            if (version == null) continue;
            return GradleVersion.tryParse((String)version);
        }
        return null;
    }

    public static boolean dependsOnAndroidTest(AndroidModuleModel androidModel, String artifact) {
        Dependencies dependencies = androidModel.getSelectedAndroidTestCompileDependencies();
        if (dependencies == null) {
            return false;
        }
        return GradleUtil.dependsOn(dependencies, artifact);
    }

    private static boolean dependsOn(Dependencies dependencies, String artifact) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!GradleUtil.dependsOn(library, artifact, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOn(AndroidLibrary library, String artifact, boolean transitively) {
        return GradleUtil.getDependencyVersion(library, artifact, transitively) != null;
    }

    private static String getDependencyVersion(AndroidLibrary library, String artifact, boolean transitively) {
        MavenCoordinates resolvedCoordinates = library.getResolvedCoordinates();
        if (resolvedCoordinates != null && artifact.endsWith(resolvedCoordinates.getArtifactId()) && artifact.equals(resolvedCoordinates.getGroupId() + ':' + resolvedCoordinates.getArtifactId())) {
            return resolvedCoordinates.getVersion();
        }
        if (transitively) {
            for (AndroidLibrary dependency : library.getLibraryDependencies()) {
                String version = GradleUtil.getDependencyVersion(dependency, artifact, true);
                if (version == null) continue;
                return version;
            }
        }
        return null;
    }

    public static boolean hasCause(@NotNull Throwable e, @NotNull Class<?> causeClass) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/util/GradleUtil", "hasCause"));
        }
        if (causeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "causeClass", "com/android/tools/idea/gradle/util/GradleUtil", "hasCause"));
        }
        String causeClassName = causeClass.getName();
        for (Throwable ex = e; ex != null; ex = ex.getCause()) {
            if (!causeClassName.equals(ex.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static File getGradleUserSettingsFile() {
        String homePath = SystemProperties.getUserHome();
        if (homePath == null) {
            return null;
        }
        return new File(homePath, FileUtil.join((String[])new String[]{".gradle", "gradle.properties"}));
    }

    public static void setBuildToolsVersion(@NotNull Project project, @NotNull String version) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleUtil", "setBuildToolsVersion"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/util/GradleUtil", "setBuildToolsVersion"));
        }
        ArrayList modelsToUpdate = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModel android;
            GradleBuildModel buildModel;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || (buildModel = GradleBuildModel.get(module)) == null || (android = buildModel.android()) == null || version.equals(android.buildToolsVersion().value())) continue;
            android.setBuildToolsVersion(version);
            modelsToUpdate.add(buildModel);
        }
        if (!modelsToUpdate.isEmpty()) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (GradleBuildModel buildModel : modelsToUpdate) {
                    buildModel.applyChanges();
                }
            });
        }
    }

    @Nullable
    public static AndroidLibrary findLibrary(@NotNull File bundleDir, @NotNull Variant variant, @Nullable GradleVersion modelVersion) {
        if (bundleDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleDir", "com/android/tools/idea/gradle/util/GradleUtil", "findLibrary"));
        }
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/util/GradleUtil", "findLibrary"));
        }
        AndroidArtifact artifact = variant.getMainArtifact();
        Dependencies dependencies = GradleUtil.getDependencies((BaseArtifact)artifact, modelVersion);
        for (AndroidLibrary library : dependencies.getLibraries()) {
            AndroidLibrary result = GradleUtil.findLibrary(library, bundleDir);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static AndroidLibrary findLibrary(@NotNull AndroidLibrary library, @NotNull File bundleDir) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/android/tools/idea/gradle/util/GradleUtil", "findLibrary"));
        }
        if (bundleDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleDir", "com/android/tools/idea/gradle/util/GradleUtil", "findLibrary"));
        }
        if (FileUtil.filesEqual((File)bundleDir, (File)library.getFolder())) {
            return library;
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            AndroidLibrary result = GradleUtil.findLibrary(dependency, bundleDir);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

