/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddUsesFeatureQuickFix
extends DefaultLintQuickFix {
    private final String myFeatureName;

    public AddUsesFeatureQuickFix(@NotNull String featureName) {
        if (featureName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureName", "com/android/tools/idea/lint/AddUsesFeatureQuickFix", "<init>"));
        }
        super("Add uses-feature tag");
        this.myFeatureName = featureName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AddUsesFeatureQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AddUsesFeatureQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lint/AddUsesFeatureQuickFix", "apply"));
        }
        XmlTag parent = (XmlTag)PsiTreeUtil.getTopmostParentOfType((PsiElement)startElement, XmlTag.class);
        if (parent == null || !"manifest".equals(parent.getName())) {
            return;
        }
        XmlTag usesFeatureTag = parent.createChildTag("uses-feature", null, null, false);
        XmlTag ancestor = AddUsesFeatureQuickFix.findLocationForUsesFeature(parent);
        usesFeatureTag = ancestor != null ? (XmlTag)parent.addAfter((PsiElement)usesFeatureTag, (PsiElement)ancestor) : parent.addSubTag(usesFeatureTag, true);
        if (usesFeatureTag != null) {
            usesFeatureTag.setAttribute("name", "http://schemas.android.com/apk/res/android", this.myFeatureName);
            usesFeatureTag.setAttribute("required", "http://schemas.android.com/apk/res/android", "false");
        }
    }

    @Nullable
    private static XmlTag findLocationForUsesFeature(XmlTag parent) {
        String[] reverseOrderManifestElements;
        for (String elementName : reverseOrderManifestElements = new String[]{"uses-feature", "uses-configuration", "uses-sdk", "permission"}) {
            XmlTag[] existingTags = parent.findSubTags(elementName);
            int len = existingTags.length;
            if (len <= 0) continue;
            return existingTags[len - 1];
        }
        return null;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AddUsesFeatureQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AddUsesFeatureQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/android/tools/idea/lint/AddUsesFeatureQuickFix", "isApplicable"));
        }
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getTopmostParentOfType((PsiElement)startElement, XmlTag.class);
        return xmlTag != null && "manifest".equals(xmlTag.getName());
    }
}

