/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintObsoleteSdkIntInspection
extends AndroidLintInspectionBase {
    public AndroidLintObsoleteSdkIntInspection() {
        super(AndroidBundle.message("android.lint.inspections.obsolete.sdk.int", new Object[0]), ApiDetector.OBSOLETE_SDK);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        PsiBinaryExpression subExpression;
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintObsoleteSdkIntInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintObsoleteSdkIntInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintObsoleteSdkIntInspection", "getQuickFixes"));
        }
        Boolean constant = ApiDetector.getVersionCheckConstant((String)message, (TextFormat)TextFormat.RAW);
        if (constant != null && (subExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiBinaryExpression.class, (boolean)false)) != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new AndroidLintQuickFix.LocalFixWrappee((LocalQuickFixOnPsiElement)new SimplifyBooleanExpressionFix((PsiExpression)subExpression, constant.booleanValue()))};
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintObsoleteSdkIntInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintObsoleteSdkIntInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

