/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintTyposInspection
extends AndroidLintInspectionBase {
    public AndroidLintTyposInspection() {
        super(AndroidBundle.message("android.lint.inspections.typos", new Object[0]), TypoDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintTyposInspection", "getQuickFixes"));
        }
        TypoDetector.TypoSuggestionInfo info = TypoDetector.getSuggestions((String)message, (TextFormat)TextFormat.RAW);
        List suggestions = info.getReplacements();
        if (!suggestions.isEmpty()) {
            ArrayList fixes = Lists.newArrayListWithExpectedSize((int)suggestions.size());
            String originalPattern = '(' + Pattern.quote(info.getOriginal()) + ')';
            for (String suggestion : suggestions) {
                fixes.add(new ReplaceStringQuickFix("Replace with \"" + suggestion + "\"", originalPattern, suggestion));
            }
            AndroidLintQuickFix[] androidLintQuickFixArray = fixes.toArray(new AndroidLintQuickFix[fixes.size()]);
            if (androidLintQuickFixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintTyposInspection", "getQuickFixes"));
            }
            return androidLintQuickFixArray;
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintTyposInspection", "getQuickFixes"));
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }
}

