/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.rendering.webp.ConvertFromWebpAction;
import com.android.tools.lint.checks.IconDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintWebpUnsupportedInspection
extends AndroidLintInspectionBase {
    public AndroidLintWebpUnsupportedInspection() {
        super(AndroidBundle.message("android.lint.inspections.webp.unsupported", new Object[0]), IconDetector.WEBP_UNSUPPORTED);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintWebpUnsupportedInspection", "getQuickFixes"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintWebpUnsupportedInspection", "getQuickFixes"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/lint/AndroidLintWebpUnsupportedInspection", "getQuickFixes"));
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ConvertWebpToPngFix()};
        if (androidLintQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/AndroidLintWebpUnsupportedInspection", "getQuickFixes"));
        }
        return androidLintQuickFixArray;
    }

    static class ConvertWebpToPngFix
    extends DefaultLintQuickFix {
        public ConvertWebpToPngFix() {
            super("Convert image to PNG");
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/android/tools/idea/lint/AndroidLintWebpUnsupportedInspection$ConvertWebpToPngFix", "apply"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/android/tools/idea/lint/AndroidLintWebpUnsupportedInspection$ConvertWebpToPngFix", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/lint/AndroidLintWebpUnsupportedInspection$ConvertWebpToPngFix", "apply"));
            }
            VirtualFile file = startElement.getContainingFile().getVirtualFile();
            if (file.exists()) {
                new ConvertFromWebpAction().perform(startElement.getProject(), new VirtualFile[]{file}, true);
            }
        }
    }
}

